<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftCard StructType
 * @subpackage Structs
 */
class GiftCard extends PaymentMethod
{
    /**
     * The activeInd
     * @var int
     */
    public $activeInd;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The internalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The redemptionAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $redemptionAmount;
    /**
     * Constructor method for giftCard
     * @uses GiftCard::setActiveInd()
     * @uses GiftCard::setAmount()
     * @uses GiftCard::setBalance()
     * @uses GiftCard::setId()
     * @uses GiftCard::setInternalId()
     * @uses GiftCard::setRedemptionAmount()
     * @param int $activeInd
     * @param float $amount
     * @param float $balance
     * @param int $id
     * @param string $internalId
     * @param float $redemptionAmount
     */
    public function __construct($activeInd = null, $amount = null, $balance = null, $id = null, $internalId = null, $redemptionAmount = null)
    {
        $this
            ->setActiveInd($activeInd)
            ->setAmount($amount)
            ->setBalance($balance)
            ->setId($id)
            ->setInternalId($internalId)
            ->setRedemptionAmount($redemptionAmount);
    }
    /**
     * Get activeInd value
     * @return int|null
     */
    public function getActiveInd()
    {
        return $this->activeInd;
    }
    /**
     * Set activeInd value
     * @param int $activeInd
     * @return \StructType\GiftCard
     */
    public function setActiveInd($activeInd = null)
    {
        // validation for constraint: int
        if (!is_null($activeInd) && !is_numeric($activeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeInd)), __LINE__);
        }
        $this->activeInd = $activeInd;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\GiftCard
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\GiftCard
     */
    public function setBalance($balance = null)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\GiftCard
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\GiftCard
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get redemptionAmount value
     * @return float|null
     */
    public function getRedemptionAmount()
    {
        return $this->redemptionAmount;
    }
    /**
     * Set redemptionAmount value
     * @param float $redemptionAmount
     * @return \StructType\GiftCard
     */
    public function setRedemptionAmount($redemptionAmount = null)
    {
        $this->redemptionAmount = $redemptionAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GiftCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
