<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for framePackage StructType
 * @subpackage Structs
 */
class FramePackage extends ExternalProductPackage
{
    /**
     * The backing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Backing
     */
    public $backing;
    /**
     * The backingBoard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatBoard
     */
    public $backingBoard;
    /**
     * The board
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Board
     */
    public $board;
    /**
     * The bottomMatIndex
     * @var int
     */
    public $bottomMatIndex;
    /**
     * The fillet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fillet
     */
    public $fillet;
    /**
     * The finishKit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FinishKit
     */
    public $finishKit;
    /**
     * The finishingOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FinishingOption[]
     */
    public $finishingOptions;
    /**
     * The floatMount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FloatMount
     */
    public $floatMount;
    /**
     * The frame
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Frame
     */
    public $frame;
    /**
     * The glazing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Glazing
     */
    public $glazing;
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Image
     */
    public $image;
    /**
     * The indicia
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrintJob[]
     */
    public $indicia;
    /**
     * The liner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Liner
     */
    public $liner;
    /**
     * The mat1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mat
     */
    public $mat1;
    /**
     * The mat2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mat
     */
    public $mat2;
    /**
     * The mat3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mat
     */
    public $mat3;
    /**
     * The matAdjust
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $matAdjust;
    /**
     * The mats
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mat[]
     */
    public $mats;
    /**
     * The mountBoard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MountBoard
     */
    public $mountBoard;
    /**
     * The mountType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mountType;
    /**
     * The nameplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Nameplate
     */
    public $nameplate;
    /**
     * The nameplates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrintJob[]
     */
    public $nameplates;
    /**
     * The outsideHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $outsideHeight;
    /**
     * The outsideWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $outsideWidth;
    /**
     * The oversizedFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OversizedFee
     */
    public $oversizedFee;
    /**
     * The packageDimensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dimension
     */
    public $packageDimensions;
    /**
     * The preferredCustomer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $preferredCustomer;
    /**
     * The printJobs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrintJob[]
     */
    public $printJobs;
    /**
     * The raisedMat1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RaisedMat
     */
    public $raisedMat1;
    /**
     * The raisedMat2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RaisedMat
     */
    public $raisedMat2;
    /**
     * The raisedMat3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RaisedMat
     */
    public $raisedMat3;
    /**
     * The reinforcementBrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalProduct
     */
    public $reinforcementBrace;
    /**
     * The reverseBevelCut1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReverseBevelCut
     */
    public $reverseBevelCut1;
    /**
     * The reverseBevelCut2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReverseBevelCut
     */
    public $reverseBevelCut2;
    /**
     * The reverseBevelCut3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReverseBevelCut
     */
    public $reverseBevelCut3;
    /**
     * The storeAssemble
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $storeAssemble;
    /**
     * The VGroove
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VGroove
     */
    public $VGroove;
    /**
     * Constructor method for framePackage
     * @uses FramePackage::setBacking()
     * @uses FramePackage::setBackingBoard()
     * @uses FramePackage::setBoard()
     * @uses FramePackage::setBottomMatIndex()
     * @uses FramePackage::setFillet()
     * @uses FramePackage::setFinishKit()
     * @uses FramePackage::setFinishingOptions()
     * @uses FramePackage::setFloatMount()
     * @uses FramePackage::setFrame()
     * @uses FramePackage::setGlazing()
     * @uses FramePackage::setImage()
     * @uses FramePackage::setIndicia()
     * @uses FramePackage::setLiner()
     * @uses FramePackage::setMat1()
     * @uses FramePackage::setMat2()
     * @uses FramePackage::setMat3()
     * @uses FramePackage::setMatAdjust()
     * @uses FramePackage::setMats()
     * @uses FramePackage::setMountBoard()
     * @uses FramePackage::setMountType()
     * @uses FramePackage::setNameplate()
     * @uses FramePackage::setNameplates()
     * @uses FramePackage::setOutsideHeight()
     * @uses FramePackage::setOutsideWidth()
     * @uses FramePackage::setOversizedFee()
     * @uses FramePackage::setPackageDimensions()
     * @uses FramePackage::setPreferredCustomer()
     * @uses FramePackage::setPrintJobs()
     * @uses FramePackage::setRaisedMat1()
     * @uses FramePackage::setRaisedMat2()
     * @uses FramePackage::setRaisedMat3()
     * @uses FramePackage::setReinforcementBrace()
     * @uses FramePackage::setReverseBevelCut1()
     * @uses FramePackage::setReverseBevelCut2()
     * @uses FramePackage::setReverseBevelCut3()
     * @uses FramePackage::setStoreAssemble()
     * @uses FramePackage::setVGroove()
     * @param \StructType\Backing $backing
     * @param \StructType\MatBoard $backingBoard
     * @param \StructType\Board $board
     * @param int $bottomMatIndex
     * @param \StructType\Fillet $fillet
     * @param \StructType\FinishKit $finishKit
     * @param \StructType\FinishingOption[] $finishingOptions
     * @param \StructType\FloatMount $floatMount
     * @param \StructType\Frame $frame
     * @param \StructType\Glazing $glazing
     * @param \StructType\Image $image
     * @param \StructType\PrintJob[] $indicia
     * @param \StructType\Liner $liner
     * @param \StructType\Mat $mat1
     * @param \StructType\Mat $mat2
     * @param \StructType\Mat $mat3
     * @param float $matAdjust
     * @param \StructType\Mat[] $mats
     * @param \StructType\MountBoard $mountBoard
     * @param string $mountType
     * @param \StructType\Nameplate $nameplate
     * @param \StructType\PrintJob[] $nameplates
     * @param float $outsideHeight
     * @param float $outsideWidth
     * @param \StructType\OversizedFee $oversizedFee
     * @param \StructType\Dimension $packageDimensions
     * @param string $preferredCustomer
     * @param \StructType\PrintJob[] $printJobs
     * @param \StructType\RaisedMat $raisedMat1
     * @param \StructType\RaisedMat $raisedMat2
     * @param \StructType\RaisedMat $raisedMat3
     * @param \StructType\ExternalProduct $reinforcementBrace
     * @param \StructType\ReverseBevelCut $reverseBevelCut1
     * @param \StructType\ReverseBevelCut $reverseBevelCut2
     * @param \StructType\ReverseBevelCut $reverseBevelCut3
     * @param bool $storeAssemble
     * @param \StructType\VGroove $vGroove
     */
    public function __construct(\StructType\Backing $backing = null, \StructType\MatBoard $backingBoard = null, \StructType\Board $board = null, $bottomMatIndex = null, \StructType\Fillet $fillet = null, \StructType\FinishKit $finishKit = null, array $finishingOptions = array(), \StructType\FloatMount $floatMount = null, \StructType\Frame $frame = null, \StructType\Glazing $glazing = null, \StructType\Image $image = null, array $indicia = array(), \StructType\Liner $liner = null, \StructType\Mat $mat1 = null, \StructType\Mat $mat2 = null, \StructType\Mat $mat3 = null, $matAdjust = null, array $mats = array(), \StructType\MountBoard $mountBoard = null, $mountType = null, \StructType\Nameplate $nameplate = null, array $nameplates = array(), $outsideHeight = null, $outsideWidth = null, \StructType\OversizedFee $oversizedFee = null, \StructType\Dimension $packageDimensions = null, $preferredCustomer = null, array $printJobs = array(), \StructType\RaisedMat $raisedMat1 = null, \StructType\RaisedMat $raisedMat2 = null, \StructType\RaisedMat $raisedMat3 = null, \StructType\ExternalProduct $reinforcementBrace = null, \StructType\ReverseBevelCut $reverseBevelCut1 = null, \StructType\ReverseBevelCut $reverseBevelCut2 = null, \StructType\ReverseBevelCut $reverseBevelCut3 = null, $storeAssemble = null, \StructType\VGroove $vGroove = null)
    {
        $this
            ->setBacking($backing)
            ->setBackingBoard($backingBoard)
            ->setBoard($board)
            ->setBottomMatIndex($bottomMatIndex)
            ->setFillet($fillet)
            ->setFinishKit($finishKit)
            ->setFinishingOptions($finishingOptions)
            ->setFloatMount($floatMount)
            ->setFrame($frame)
            ->setGlazing($glazing)
            ->setImage($image)
            ->setIndicia($indicia)
            ->setLiner($liner)
            ->setMat1($mat1)
            ->setMat2($mat2)
            ->setMat3($mat3)
            ->setMatAdjust($matAdjust)
            ->setMats($mats)
            ->setMountBoard($mountBoard)
            ->setMountType($mountType)
            ->setNameplate($nameplate)
            ->setNameplates($nameplates)
            ->setOutsideHeight($outsideHeight)
            ->setOutsideWidth($outsideWidth)
            ->setOversizedFee($oversizedFee)
            ->setPackageDimensions($packageDimensions)
            ->setPreferredCustomer($preferredCustomer)
            ->setPrintJobs($printJobs)
            ->setRaisedMat1($raisedMat1)
            ->setRaisedMat2($raisedMat2)
            ->setRaisedMat3($raisedMat3)
            ->setReinforcementBrace($reinforcementBrace)
            ->setReverseBevelCut1($reverseBevelCut1)
            ->setReverseBevelCut2($reverseBevelCut2)
            ->setReverseBevelCut3($reverseBevelCut3)
            ->setStoreAssemble($storeAssemble)
            ->setVGroove($vGroove);
    }
    /**
     * Get backing value
     * @return \StructType\Backing|null
     */
    public function getBacking()
    {
        return $this->backing;
    }
    /**
     * Set backing value
     * @param \StructType\Backing $backing
     * @return \StructType\FramePackage
     */
    public function setBacking(\StructType\Backing $backing = null)
    {
        $this->backing = $backing;
        return $this;
    }
    /**
     * Get backingBoard value
     * @return \StructType\MatBoard|null
     */
    public function getBackingBoard()
    {
        return $this->backingBoard;
    }
    /**
     * Set backingBoard value
     * @param \StructType\MatBoard $backingBoard
     * @return \StructType\FramePackage
     */
    public function setBackingBoard(\StructType\MatBoard $backingBoard = null)
    {
        $this->backingBoard = $backingBoard;
        return $this;
    }
    /**
     * Get board value
     * @return \StructType\Board|null
     */
    public function getBoard()
    {
        return $this->board;
    }
    /**
     * Set board value
     * @param \StructType\Board $board
     * @return \StructType\FramePackage
     */
    public function setBoard(\StructType\Board $board = null)
    {
        $this->board = $board;
        return $this;
    }
    /**
     * Get bottomMatIndex value
     * @return int|null
     */
    public function getBottomMatIndex()
    {
        return $this->bottomMatIndex;
    }
    /**
     * Set bottomMatIndex value
     * @param int $bottomMatIndex
     * @return \StructType\FramePackage
     */
    public function setBottomMatIndex($bottomMatIndex = null)
    {
        // validation for constraint: int
        if (!is_null($bottomMatIndex) && !is_numeric($bottomMatIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bottomMatIndex)), __LINE__);
        }
        $this->bottomMatIndex = $bottomMatIndex;
        return $this;
    }
    /**
     * Get fillet value
     * @return \StructType\Fillet|null
     */
    public function getFillet()
    {
        return $this->fillet;
    }
    /**
     * Set fillet value
     * @param \StructType\Fillet $fillet
     * @return \StructType\FramePackage
     */
    public function setFillet(\StructType\Fillet $fillet = null)
    {
        $this->fillet = $fillet;
        return $this;
    }
    /**
     * Get finishKit value
     * @return \StructType\FinishKit|null
     */
    public function getFinishKit()
    {
        return $this->finishKit;
    }
    /**
     * Set finishKit value
     * @param \StructType\FinishKit $finishKit
     * @return \StructType\FramePackage
     */
    public function setFinishKit(\StructType\FinishKit $finishKit = null)
    {
        $this->finishKit = $finishKit;
        return $this;
    }
    /**
     * Get finishingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FinishingOption[]|null
     */
    public function getFinishingOptions()
    {
        return isset($this->finishingOptions) ? $this->finishingOptions : null;
    }
    /**
     * Set finishingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FinishingOption[] $finishingOptions
     * @return \StructType\FramePackage
     */
    public function setFinishingOptions(array $finishingOptions = array())
    {
        foreach ($finishingOptions as $framePackageFinishingOptionsItem) {
            // validation for constraint: itemType
            if (!$framePackageFinishingOptionsItem instanceof \StructType\FinishingOption) {
                throw new \InvalidArgumentException(sprintf('The finishingOptions property can only contain items of \StructType\FinishingOption, "%s" given', is_object($framePackageFinishingOptionsItem) ? get_class($framePackageFinishingOptionsItem) : gettype($framePackageFinishingOptionsItem)), __LINE__);
            }
        }
        if (is_null($finishingOptions) || (is_array($finishingOptions) && empty($finishingOptions))) {
            unset($this->finishingOptions);
        } else {
            $this->finishingOptions = $finishingOptions;
        }
        return $this;
    }
    /**
     * Add item to finishingOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\FinishingOption $item
     * @return \StructType\FramePackage
     */
    public function addToFinishingOptions(\StructType\FinishingOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FinishingOption) {
            throw new \InvalidArgumentException(sprintf('The finishingOptions property can only contain items of \StructType\FinishingOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->finishingOptions[] = $item;
        return $this;
    }
    /**
     * Get floatMount value
     * @return \StructType\FloatMount|null
     */
    public function getFloatMount()
    {
        return $this->floatMount;
    }
    /**
     * Set floatMount value
     * @param \StructType\FloatMount $floatMount
     * @return \StructType\FramePackage
     */
    public function setFloatMount(\StructType\FloatMount $floatMount = null)
    {
        $this->floatMount = $floatMount;
        return $this;
    }
    /**
     * Get frame value
     * @return \StructType\Frame|null
     */
    public function getFrame()
    {
        return $this->frame;
    }
    /**
     * Set frame value
     * @param \StructType\Frame $frame
     * @return \StructType\FramePackage
     */
    public function setFrame(\StructType\Frame $frame = null)
    {
        $this->frame = $frame;
        return $this;
    }
    /**
     * Get glazing value
     * @return \StructType\Glazing|null
     */
    public function getGlazing()
    {
        return $this->glazing;
    }
    /**
     * Set glazing value
     * @param \StructType\Glazing $glazing
     * @return \StructType\FramePackage
     */
    public function setGlazing(\StructType\Glazing $glazing = null)
    {
        $this->glazing = $glazing;
        return $this;
    }
    /**
     * Get image value
     * @return \StructType\Image|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\Image $image
     * @return \StructType\FramePackage
     */
    public function setImage(\StructType\Image $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get indicia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrintJob[]|null
     */
    public function getIndicia()
    {
        return isset($this->indicia) ? $this->indicia : null;
    }
    /**
     * Set indicia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob[] $indicia
     * @return \StructType\FramePackage
     */
    public function setIndicia(array $indicia = array())
    {
        foreach ($indicia as $framePackageIndiciaItem) {
            // validation for constraint: itemType
            if (!$framePackageIndiciaItem instanceof \StructType\PrintJob) {
                throw new \InvalidArgumentException(sprintf('The indicia property can only contain items of \StructType\PrintJob, "%s" given', is_object($framePackageIndiciaItem) ? get_class($framePackageIndiciaItem) : gettype($framePackageIndiciaItem)), __LINE__);
            }
        }
        if (is_null($indicia) || (is_array($indicia) && empty($indicia))) {
            unset($this->indicia);
        } else {
            $this->indicia = $indicia;
        }
        return $this;
    }
    /**
     * Add item to indicia value
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob $item
     * @return \StructType\FramePackage
     */
    public function addToIndicia(\StructType\PrintJob $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrintJob) {
            throw new \InvalidArgumentException(sprintf('The indicia property can only contain items of \StructType\PrintJob, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->indicia[] = $item;
        return $this;
    }
    /**
     * Get liner value
     * @return \StructType\Liner|null
     */
    public function getLiner()
    {
        return $this->liner;
    }
    /**
     * Set liner value
     * @param \StructType\Liner $liner
     * @return \StructType\FramePackage
     */
    public function setLiner(\StructType\Liner $liner = null)
    {
        $this->liner = $liner;
        return $this;
    }
    /**
     * Get mat1 value
     * @return \StructType\Mat|null
     */
    public function getMat1()
    {
        return $this->mat1;
    }
    /**
     * Set mat1 value
     * @param \StructType\Mat $mat1
     * @return \StructType\FramePackage
     */
    public function setMat1(\StructType\Mat $mat1 = null)
    {
        $this->mat1 = $mat1;
        return $this;
    }
    /**
     * Get mat2 value
     * @return \StructType\Mat|null
     */
    public function getMat2()
    {
        return $this->mat2;
    }
    /**
     * Set mat2 value
     * @param \StructType\Mat $mat2
     * @return \StructType\FramePackage
     */
    public function setMat2(\StructType\Mat $mat2 = null)
    {
        $this->mat2 = $mat2;
        return $this;
    }
    /**
     * Get mat3 value
     * @return \StructType\Mat|null
     */
    public function getMat3()
    {
        return $this->mat3;
    }
    /**
     * Set mat3 value
     * @param \StructType\Mat $mat3
     * @return \StructType\FramePackage
     */
    public function setMat3(\StructType\Mat $mat3 = null)
    {
        $this->mat3 = $mat3;
        return $this;
    }
    /**
     * Get matAdjust value
     * @return float|null
     */
    public function getMatAdjust()
    {
        return $this->matAdjust;
    }
    /**
     * Set matAdjust value
     * @param float $matAdjust
     * @return \StructType\FramePackage
     */
    public function setMatAdjust($matAdjust = null)
    {
        $this->matAdjust = $matAdjust;
        return $this;
    }
    /**
     * Get mats value
     * @return \StructType\Mat[]|null
     */
    public function getMats()
    {
        return $this->mats;
    }
    /**
     * Set mats value
     * @throws \InvalidArgumentException
     * @param \StructType\Mat[] $mats
     * @return \StructType\FramePackage
     */
    public function setMats(array $mats = array())
    {
        foreach ($mats as $framePackageMatsItem) {
            // validation for constraint: itemType
            if (!$framePackageMatsItem instanceof \StructType\Mat) {
                throw new \InvalidArgumentException(sprintf('The mats property can only contain items of \StructType\Mat, "%s" given', is_object($framePackageMatsItem) ? get_class($framePackageMatsItem) : gettype($framePackageMatsItem)), __LINE__);
            }
        }
        $this->mats = $mats;
        return $this;
    }
    /**
     * Add item to mats value
     * @throws \InvalidArgumentException
     * @param \StructType\Mat $item
     * @return \StructType\FramePackage
     */
    public function addToMats(\StructType\Mat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mat) {
            throw new \InvalidArgumentException(sprintf('The mats property can only contain items of \StructType\Mat, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mats[] = $item;
        return $this;
    }
    /**
     * Get mountBoard value
     * @return \StructType\MountBoard|null
     */
    public function getMountBoard()
    {
        return $this->mountBoard;
    }
    /**
     * Set mountBoard value
     * @param \StructType\MountBoard $mountBoard
     * @return \StructType\FramePackage
     */
    public function setMountBoard(\StructType\MountBoard $mountBoard = null)
    {
        $this->mountBoard = $mountBoard;
        return $this;
    }
    /**
     * Get mountType value
     * @return string|null
     */
    public function getMountType()
    {
        return $this->mountType;
    }
    /**
     * Set mountType value
     * @param string $mountType
     * @return \StructType\FramePackage
     */
    public function setMountType($mountType = null)
    {
        // validation for constraint: string
        if (!is_null($mountType) && !is_string($mountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mountType)), __LINE__);
        }
        $this->mountType = $mountType;
        return $this;
    }
    /**
     * Get nameplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Nameplate|null
     */
    public function getNameplate()
    {
        return isset($this->nameplate) ? $this->nameplate : null;
    }
    /**
     * Set nameplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Nameplate $nameplate
     * @return \StructType\FramePackage
     */
    public function setNameplate(\StructType\Nameplate $nameplate = null)
    {
        if (is_null($nameplate) || (is_array($nameplate) && empty($nameplate))) {
            unset($this->nameplate);
        } else {
            $this->nameplate = $nameplate;
        }
        return $this;
    }
    /**
     * Get nameplates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrintJob[]|null
     */
    public function getNameplates()
    {
        return isset($this->nameplates) ? $this->nameplates : null;
    }
    /**
     * Set nameplates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob[] $nameplates
     * @return \StructType\FramePackage
     */
    public function setNameplates(array $nameplates = array())
    {
        foreach ($nameplates as $framePackageNameplatesItem) {
            // validation for constraint: itemType
            if (!$framePackageNameplatesItem instanceof \StructType\PrintJob) {
                throw new \InvalidArgumentException(sprintf('The nameplates property can only contain items of \StructType\PrintJob, "%s" given', is_object($framePackageNameplatesItem) ? get_class($framePackageNameplatesItem) : gettype($framePackageNameplatesItem)), __LINE__);
            }
        }
        if (is_null($nameplates) || (is_array($nameplates) && empty($nameplates))) {
            unset($this->nameplates);
        } else {
            $this->nameplates = $nameplates;
        }
        return $this;
    }
    /**
     * Add item to nameplates value
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob $item
     * @return \StructType\FramePackage
     */
    public function addToNameplates(\StructType\PrintJob $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrintJob) {
            throw new \InvalidArgumentException(sprintf('The nameplates property can only contain items of \StructType\PrintJob, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nameplates[] = $item;
        return $this;
    }
    /**
     * Get outsideHeight value
     * @return float|null
     */
    public function getOutsideHeight()
    {
        return $this->outsideHeight;
    }
    /**
     * Set outsideHeight value
     * @param float $outsideHeight
     * @return \StructType\FramePackage
     */
    public function setOutsideHeight($outsideHeight = null)
    {
        $this->outsideHeight = $outsideHeight;
        return $this;
    }
    /**
     * Get outsideWidth value
     * @return float|null
     */
    public function getOutsideWidth()
    {
        return $this->outsideWidth;
    }
    /**
     * Set outsideWidth value
     * @param float $outsideWidth
     * @return \StructType\FramePackage
     */
    public function setOutsideWidth($outsideWidth = null)
    {
        $this->outsideWidth = $outsideWidth;
        return $this;
    }
    /**
     * Get oversizedFee value
     * @return \StructType\OversizedFee|null
     */
    public function getOversizedFee()
    {
        return $this->oversizedFee;
    }
    /**
     * Set oversizedFee value
     * @param \StructType\OversizedFee $oversizedFee
     * @return \StructType\FramePackage
     */
    public function setOversizedFee(\StructType\OversizedFee $oversizedFee = null)
    {
        $this->oversizedFee = $oversizedFee;
        return $this;
    }
    /**
     * Get packageDimensions value
     * @return \StructType\Dimension|null
     */
    public function getPackageDimensions()
    {
        return $this->packageDimensions;
    }
    /**
     * Set packageDimensions value
     * @param \StructType\Dimension $packageDimensions
     * @return \StructType\FramePackage
     */
    public function setPackageDimensions(\StructType\Dimension $packageDimensions = null)
    {
        $this->packageDimensions = $packageDimensions;
        return $this;
    }
    /**
     * Get preferredCustomer value
     * @return string|null
     */
    public function getPreferredCustomer()
    {
        return $this->preferredCustomer;
    }
    /**
     * Set preferredCustomer value
     * @param string $preferredCustomer
     * @return \StructType\FramePackage
     */
    public function setPreferredCustomer($preferredCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCustomer) && !is_string($preferredCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredCustomer)), __LINE__);
        }
        $this->preferredCustomer = $preferredCustomer;
        return $this;
    }
    /**
     * Get printJobs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrintJob[]|null
     */
    public function getPrintJobs()
    {
        return isset($this->printJobs) ? $this->printJobs : null;
    }
    /**
     * Set printJobs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob[] $printJobs
     * @return \StructType\FramePackage
     */
    public function setPrintJobs(array $printJobs = array())
    {
        foreach ($printJobs as $framePackagePrintJobsItem) {
            // validation for constraint: itemType
            if (!$framePackagePrintJobsItem instanceof \StructType\PrintJob) {
                throw new \InvalidArgumentException(sprintf('The printJobs property can only contain items of \StructType\PrintJob, "%s" given', is_object($framePackagePrintJobsItem) ? get_class($framePackagePrintJobsItem) : gettype($framePackagePrintJobsItem)), __LINE__);
            }
        }
        if (is_null($printJobs) || (is_array($printJobs) && empty($printJobs))) {
            unset($this->printJobs);
        } else {
            $this->printJobs = $printJobs;
        }
        return $this;
    }
    /**
     * Add item to printJobs value
     * @throws \InvalidArgumentException
     * @param \StructType\PrintJob $item
     * @return \StructType\FramePackage
     */
    public function addToPrintJobs(\StructType\PrintJob $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrintJob) {
            throw new \InvalidArgumentException(sprintf('The printJobs property can only contain items of \StructType\PrintJob, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->printJobs[] = $item;
        return $this;
    }
    /**
     * Get raisedMat1 value
     * @return \StructType\RaisedMat|null
     */
    public function getRaisedMat1()
    {
        return $this->raisedMat1;
    }
    /**
     * Set raisedMat1 value
     * @param \StructType\RaisedMat $raisedMat1
     * @return \StructType\FramePackage
     */
    public function setRaisedMat1(\StructType\RaisedMat $raisedMat1 = null)
    {
        $this->raisedMat1 = $raisedMat1;
        return $this;
    }
    /**
     * Get raisedMat2 value
     * @return \StructType\RaisedMat|null
     */
    public function getRaisedMat2()
    {
        return $this->raisedMat2;
    }
    /**
     * Set raisedMat2 value
     * @param \StructType\RaisedMat $raisedMat2
     * @return \StructType\FramePackage
     */
    public function setRaisedMat2(\StructType\RaisedMat $raisedMat2 = null)
    {
        $this->raisedMat2 = $raisedMat2;
        return $this;
    }
    /**
     * Get raisedMat3 value
     * @return \StructType\RaisedMat|null
     */
    public function getRaisedMat3()
    {
        return $this->raisedMat3;
    }
    /**
     * Set raisedMat3 value
     * @param \StructType\RaisedMat $raisedMat3
     * @return \StructType\FramePackage
     */
    public function setRaisedMat3(\StructType\RaisedMat $raisedMat3 = null)
    {
        $this->raisedMat3 = $raisedMat3;
        return $this;
    }
    /**
     * Get reinforcementBrace value
     * @return \StructType\ExternalProduct|null
     */
    public function getReinforcementBrace()
    {
        return $this->reinforcementBrace;
    }
    /**
     * Set reinforcementBrace value
     * @param \StructType\ExternalProduct $reinforcementBrace
     * @return \StructType\FramePackage
     */
    public function setReinforcementBrace(\StructType\ExternalProduct $reinforcementBrace = null)
    {
        $this->reinforcementBrace = $reinforcementBrace;
        return $this;
    }
    /**
     * Get reverseBevelCut1 value
     * @return \StructType\ReverseBevelCut|null
     */
    public function getReverseBevelCut1()
    {
        return $this->reverseBevelCut1;
    }
    /**
     * Set reverseBevelCut1 value
     * @param \StructType\ReverseBevelCut $reverseBevelCut1
     * @return \StructType\FramePackage
     */
    public function setReverseBevelCut1(\StructType\ReverseBevelCut $reverseBevelCut1 = null)
    {
        $this->reverseBevelCut1 = $reverseBevelCut1;
        return $this;
    }
    /**
     * Get reverseBevelCut2 value
     * @return \StructType\ReverseBevelCut|null
     */
    public function getReverseBevelCut2()
    {
        return $this->reverseBevelCut2;
    }
    /**
     * Set reverseBevelCut2 value
     * @param \StructType\ReverseBevelCut $reverseBevelCut2
     * @return \StructType\FramePackage
     */
    public function setReverseBevelCut2(\StructType\ReverseBevelCut $reverseBevelCut2 = null)
    {
        $this->reverseBevelCut2 = $reverseBevelCut2;
        return $this;
    }
    /**
     * Get reverseBevelCut3 value
     * @return \StructType\ReverseBevelCut|null
     */
    public function getReverseBevelCut3()
    {
        return $this->reverseBevelCut3;
    }
    /**
     * Set reverseBevelCut3 value
     * @param \StructType\ReverseBevelCut $reverseBevelCut3
     * @return \StructType\FramePackage
     */
    public function setReverseBevelCut3(\StructType\ReverseBevelCut $reverseBevelCut3 = null)
    {
        $this->reverseBevelCut3 = $reverseBevelCut3;
        return $this;
    }
    /**
     * Get storeAssemble value
     * @return bool|null
     */
    public function getStoreAssemble()
    {
        return $this->storeAssemble;
    }
    /**
     * Set storeAssemble value
     * @param bool $storeAssemble
     * @return \StructType\FramePackage
     */
    public function setStoreAssemble($storeAssemble = null)
    {
        $this->storeAssemble = $storeAssemble;
        return $this;
    }
    /**
     * Get VGroove value
     * @return \StructType\VGroove|null
     */
    public function getVGroove()
    {
        return $this->VGroove;
    }
    /**
     * Set VGroove value
     * @param \StructType\VGroove $vGroove
     * @return \StructType\FramePackage
     */
    public function setVGroove(\StructType\VGroove $vGroove = null)
    {
        $this->VGroove = $vGroove;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FramePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
