<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProductTypeDef StructType
 * @subpackage Structs
 */
class ExternalProductTypeDef extends AbstractStructBase
{
    /**
     * The allowanceInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $allowanceInd;
    /**
     * The attributeTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attributeTypeCode;
    /**
     * The externalProductAttributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProductAttribute[]
     */
    public $externalProductAttributes;
    /**
     * The multiInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $multiInd;
    /**
     * Constructor method for externalProductTypeDef
     * @uses ExternalProductTypeDef::setAllowanceInd()
     * @uses ExternalProductTypeDef::setAttributeTypeCode()
     * @uses ExternalProductTypeDef::setExternalProductAttributes()
     * @uses ExternalProductTypeDef::setMultiInd()
     * @param int $allowanceInd
     * @param string $attributeTypeCode
     * @param \StructType\ExternalProductAttribute[] $externalProductAttributes
     * @param int $multiInd
     */
    public function __construct($allowanceInd = null, $attributeTypeCode = null, array $externalProductAttributes = array(), $multiInd = null)
    {
        $this
            ->setAllowanceInd($allowanceInd)
            ->setAttributeTypeCode($attributeTypeCode)
            ->setExternalProductAttributes($externalProductAttributes)
            ->setMultiInd($multiInd);
    }
    /**
     * Get allowanceInd value
     * @return int|null
     */
    public function getAllowanceInd()
    {
        return $this->allowanceInd;
    }
    /**
     * Set allowanceInd value
     * @param int $allowanceInd
     * @return \StructType\ExternalProductTypeDef
     */
    public function setAllowanceInd($allowanceInd = null)
    {
        // validation for constraint: int
        if (!is_null($allowanceInd) && !is_numeric($allowanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allowanceInd)), __LINE__);
        }
        $this->allowanceInd = $allowanceInd;
        return $this;
    }
    /**
     * Get attributeTypeCode value
     * @return string|null
     */
    public function getAttributeTypeCode()
    {
        return $this->attributeTypeCode;
    }
    /**
     * Set attributeTypeCode value
     * @param string $attributeTypeCode
     * @return \StructType\ExternalProductTypeDef
     */
    public function setAttributeTypeCode($attributeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($attributeTypeCode) && !is_string($attributeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeTypeCode)), __LINE__);
        }
        $this->attributeTypeCode = $attributeTypeCode;
        return $this;
    }
    /**
     * Get externalProductAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProductAttribute[]|null
     */
    public function getExternalProductAttributes()
    {
        return isset($this->externalProductAttributes) ? $this->externalProductAttributes : null;
    }
    /**
     * Set externalProductAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute[] $externalProductAttributes
     * @return \StructType\ExternalProductTypeDef
     */
    public function setExternalProductAttributes(array $externalProductAttributes = array())
    {
        foreach ($externalProductAttributes as $externalProductTypeDefExternalProductAttributesItem) {
            // validation for constraint: itemType
            if (!$externalProductTypeDefExternalProductAttributesItem instanceof \StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($externalProductTypeDefExternalProductAttributesItem) ? get_class($externalProductTypeDefExternalProductAttributesItem) : gettype($externalProductTypeDefExternalProductAttributesItem)), __LINE__);
            }
        }
        if (is_null($externalProductAttributes) || (is_array($externalProductAttributes) && empty($externalProductAttributes))) {
            unset($this->externalProductAttributes);
        } else {
            $this->externalProductAttributes = $externalProductAttributes;
        }
        return $this;
    }
    /**
     * Add item to externalProductAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute $item
     * @return \StructType\ExternalProductTypeDef
     */
    public function addToExternalProductAttributes(\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttributes[] = $item;
        return $this;
    }
    /**
     * Get multiInd value
     * @return int|null
     */
    public function getMultiInd()
    {
        return $this->multiInd;
    }
    /**
     * Set multiInd value
     * @param int $multiInd
     * @return \StructType\ExternalProductTypeDef
     */
    public function setMultiInd($multiInd = null)
    {
        // validation for constraint: int
        if (!is_null($multiInd) && !is_numeric($multiInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($multiInd)), __LINE__);
        }
        $this->multiInd = $multiInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalProductTypeDef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
