<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProductGroup StructType
 * @subpackage Structs
 */
class ExternalProductGroup extends AbstractStructBase
{
    /**
     * The complexDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ComplexDescription
     */
    public $complexDescription;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The externalProductAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProductAttribute[]
     */
    public $externalProductAttribute;
    /**
     * The externalProductAttributeGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProductAttributeGroup[]
     */
    public $externalProductAttributeGroups;
    /**
     * The externalProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProduct[]
     */
    public $externalProducts;
    /**
     * The groupName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $groupName;
    /**
     * The productGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productGroupId;
    /**
     * The productSkus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $productSkus;
    /**
     * Constructor method for externalProductGroup
     * @uses ExternalProductGroup::setComplexDescription()
     * @uses ExternalProductGroup::setDescription()
     * @uses ExternalProductGroup::setExternalProductAttribute()
     * @uses ExternalProductGroup::setExternalProductAttributeGroups()
     * @uses ExternalProductGroup::setExternalProducts()
     * @uses ExternalProductGroup::setGroupName()
     * @uses ExternalProductGroup::setProductGroupId()
     * @uses ExternalProductGroup::setProductSkus()
     * @param \StructType\ComplexDescription $complexDescription
     * @param string $description
     * @param \StructType\ExternalProductAttribute[] $externalProductAttribute
     * @param \StructType\ExternalProductAttributeGroup[] $externalProductAttributeGroups
     * @param \StructType\ExternalProduct[] $externalProducts
     * @param string $groupName
     * @param int $productGroupId
     * @param string[] $productSkus
     */
    public function __construct(\StructType\ComplexDescription $complexDescription = null, $description = null, array $externalProductAttribute = array(), array $externalProductAttributeGroups = array(), array $externalProducts = array(), $groupName = null, $productGroupId = null, array $productSkus = array())
    {
        $this
            ->setComplexDescription($complexDescription)
            ->setDescription($description)
            ->setExternalProductAttribute($externalProductAttribute)
            ->setExternalProductAttributeGroups($externalProductAttributeGroups)
            ->setExternalProducts($externalProducts)
            ->setGroupName($groupName)
            ->setProductGroupId($productGroupId)
            ->setProductSkus($productSkus);
    }
    /**
     * Get complexDescription value
     * @return \StructType\ComplexDescription|null
     */
    public function getComplexDescription()
    {
        return $this->complexDescription;
    }
    /**
     * Set complexDescription value
     * @param \StructType\ComplexDescription $complexDescription
     * @return \StructType\ExternalProductGroup
     */
    public function setComplexDescription(\StructType\ComplexDescription $complexDescription = null)
    {
        $this->complexDescription = $complexDescription;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExternalProductGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get externalProductAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProductAttribute[]|null
     */
    public function getExternalProductAttribute()
    {
        return isset($this->externalProductAttribute) ? $this->externalProductAttribute : null;
    }
    /**
     * Set externalProductAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute[] $externalProductAttribute
     * @return \StructType\ExternalProductGroup
     */
    public function setExternalProductAttribute(array $externalProductAttribute = array())
    {
        foreach ($externalProductAttribute as $externalProductGroupExternalProductAttributeItem) {
            // validation for constraint: itemType
            if (!$externalProductGroupExternalProductAttributeItem instanceof \StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttribute property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($externalProductGroupExternalProductAttributeItem) ? get_class($externalProductGroupExternalProductAttributeItem) : gettype($externalProductGroupExternalProductAttributeItem)), __LINE__);
            }
        }
        if (is_null($externalProductAttribute) || (is_array($externalProductAttribute) && empty($externalProductAttribute))) {
            unset($this->externalProductAttribute);
        } else {
            $this->externalProductAttribute = $externalProductAttribute;
        }
        return $this;
    }
    /**
     * Add item to externalProductAttribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute $item
     * @return \StructType\ExternalProductGroup
     */
    public function addToExternalProductAttribute(\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttribute property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttribute[] = $item;
        return $this;
    }
    /**
     * Get externalProductAttributeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProductAttributeGroup[]|null
     */
    public function getExternalProductAttributeGroups()
    {
        return isset($this->externalProductAttributeGroups) ? $this->externalProductAttributeGroups : null;
    }
    /**
     * Set externalProductAttributeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttributeGroup[] $externalProductAttributeGroups
     * @return \StructType\ExternalProductGroup
     */
    public function setExternalProductAttributeGroups(array $externalProductAttributeGroups = array())
    {
        foreach ($externalProductAttributeGroups as $externalProductGroupExternalProductAttributeGroupsItem) {
            // validation for constraint: itemType
            if (!$externalProductGroupExternalProductAttributeGroupsItem instanceof \StructType\ExternalProductAttributeGroup) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttributeGroups property can only contain items of \StructType\ExternalProductAttributeGroup, "%s" given', is_object($externalProductGroupExternalProductAttributeGroupsItem) ? get_class($externalProductGroupExternalProductAttributeGroupsItem) : gettype($externalProductGroupExternalProductAttributeGroupsItem)), __LINE__);
            }
        }
        if (is_null($externalProductAttributeGroups) || (is_array($externalProductAttributeGroups) && empty($externalProductAttributeGroups))) {
            unset($this->externalProductAttributeGroups);
        } else {
            $this->externalProductAttributeGroups = $externalProductAttributeGroups;
        }
        return $this;
    }
    /**
     * Add item to externalProductAttributeGroups value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttributeGroup $item
     * @return \StructType\ExternalProductGroup
     */
    public function addToExternalProductAttributeGroups(\StructType\ExternalProductAttributeGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductAttributeGroup) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttributeGroups property can only contain items of \StructType\ExternalProductAttributeGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttributeGroups[] = $item;
        return $this;
    }
    /**
     * Get externalProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProduct[]|null
     */
    public function getExternalProducts()
    {
        return isset($this->externalProducts) ? $this->externalProducts : null;
    }
    /**
     * Set externalProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProduct[] $externalProducts
     * @return \StructType\ExternalProductGroup
     */
    public function setExternalProducts(array $externalProducts = array())
    {
        foreach ($externalProducts as $externalProductGroupExternalProductsItem) {
            // validation for constraint: itemType
            if (!$externalProductGroupExternalProductsItem instanceof \StructType\ExternalProduct) {
                throw new \InvalidArgumentException(sprintf('The externalProducts property can only contain items of \StructType\ExternalProduct, "%s" given', is_object($externalProductGroupExternalProductsItem) ? get_class($externalProductGroupExternalProductsItem) : gettype($externalProductGroupExternalProductsItem)), __LINE__);
            }
        }
        if (is_null($externalProducts) || (is_array($externalProducts) && empty($externalProducts))) {
            unset($this->externalProducts);
        } else {
            $this->externalProducts = $externalProducts;
        }
        return $this;
    }
    /**
     * Add item to externalProducts value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProduct $item
     * @return \StructType\ExternalProductGroup
     */
    public function addToExternalProducts(\StructType\ExternalProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProduct) {
            throw new \InvalidArgumentException(sprintf('The externalProducts property can only contain items of \StructType\ExternalProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProducts[] = $item;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\ExternalProductGroup
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Get productGroupId value
     * @return int|null
     */
    public function getProductGroupId()
    {
        return $this->productGroupId;
    }
    /**
     * Set productGroupId value
     * @param int $productGroupId
     * @return \StructType\ExternalProductGroup
     */
    public function setProductGroupId($productGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($productGroupId) && !is_numeric($productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productGroupId)), __LINE__);
        }
        $this->productGroupId = $productGroupId;
        return $this;
    }
    /**
     * Get productSkus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getProductSkus()
    {
        return isset($this->productSkus) ? $this->productSkus : null;
    }
    /**
     * Set productSkus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $productSkus
     * @return \StructType\ExternalProductGroup
     */
    public function setProductSkus(array $productSkus = array())
    {
        foreach ($productSkus as $externalProductGroupProductSkusItem) {
            // validation for constraint: itemType
            if (!is_string($externalProductGroupProductSkusItem)) {
                throw new \InvalidArgumentException(sprintf('The productSkus property can only contain items of string, "%s" given', is_object($externalProductGroupProductSkusItem) ? get_class($externalProductGroupProductSkusItem) : gettype($externalProductGroupProductSkusItem)), __LINE__);
            }
        }
        if (is_null($productSkus) || (is_array($productSkus) && empty($productSkus))) {
            unset($this->productSkus);
        } else {
            $this->productSkus = $productSkus;
        }
        return $this;
    }
    /**
     * Add item to productSkus value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExternalProductGroup
     */
    public function addToProductSkus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The productSkus property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productSkus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalProductGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
