<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProduct StructType
 * @subpackage Structs
 */
class ExternalProduct extends AbstractStructBase
{
    /**
     * The additionalFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionalFee;
    /**
     * The additionalFeeDiscounted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionalFeeDiscounted;
    /**
     * The availableInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $availableInd;
    /**
     * The backOrderInv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $backOrderInv;
    /**
     * The backorderDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $backorderDate;
    /**
     * The complexDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ComplexDescription
     */
    public $complexDescription;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The externalProductAttributeGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProductAttributeGroup[]
     */
    public $externalProductAttributeGroups;
    /**
     * The externalProductAttributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalProductAttribute[]
     */
    public $externalProductAttributes;
    /**
     * The externalProductGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalProductGroup[]
     */
    public $externalProductGroups;
    /**
     * The externalProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalProductType
     */
    public $externalProductType;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The keywords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $keywords;
    /**
     * The masterSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $masterSku;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The noDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $noDiscount;
    /**
     * The onHandInv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $onHandInv;
    /**
     * The orderQty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderQty;
    /**
     * The overallLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $overallLength;
    /**
     * The priceData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceData
     */
    public $priceData;
    /**
     * The productImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productImage;
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productName;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The rootSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rootSku;
    /**
     * The shortDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortDescription;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortOrder;
    /**
     * The translatedSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $translatedSku;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The udInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $udInd;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $userId;
    /**
     * The users
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalUser[]
     */
    public $users;
    /**
     * Constructor method for externalProduct
     * @uses ExternalProduct::setAdditionalFee()
     * @uses ExternalProduct::setAdditionalFeeDiscounted()
     * @uses ExternalProduct::setAvailableInd()
     * @uses ExternalProduct::setBackOrderInv()
     * @uses ExternalProduct::setBackorderDate()
     * @uses ExternalProduct::setComplexDescription()
     * @uses ExternalProduct::setDescription()
     * @uses ExternalProduct::setExternalProductAttributeGroups()
     * @uses ExternalProduct::setExternalProductAttributes()
     * @uses ExternalProduct::setExternalProductGroups()
     * @uses ExternalProduct::setExternalProductType()
     * @uses ExternalProduct::setId()
     * @uses ExternalProduct::setKeywords()
     * @uses ExternalProduct::setMasterSku()
     * @uses ExternalProduct::setName()
     * @uses ExternalProduct::setNoDiscount()
     * @uses ExternalProduct::setOnHandInv()
     * @uses ExternalProduct::setOrderQty()
     * @uses ExternalProduct::setOverallLength()
     * @uses ExternalProduct::setPriceData()
     * @uses ExternalProduct::setProductImage()
     * @uses ExternalProduct::setProductName()
     * @uses ExternalProduct::setProductType()
     * @uses ExternalProduct::setRootSku()
     * @uses ExternalProduct::setShortDescription()
     * @uses ExternalProduct::setSku()
     * @uses ExternalProduct::setSortOrder()
     * @uses ExternalProduct::setTranslatedSku()
     * @uses ExternalProduct::setType()
     * @uses ExternalProduct::setUdInd()
     * @uses ExternalProduct::setUserId()
     * @uses ExternalProduct::setUsers()
     * @param float $additionalFee
     * @param float $additionalFeeDiscounted
     * @param int $availableInd
     * @param int $backOrderInv
     * @param string $backorderDate
     * @param \StructType\ComplexDescription $complexDescription
     * @param string $description
     * @param \StructType\ExternalProductAttributeGroup[] $externalProductAttributeGroups
     * @param \StructType\ExternalProductAttribute[] $externalProductAttributes
     * @param \StructType\ExternalProductGroup[] $externalProductGroups
     * @param \StructType\ExternalProductType $externalProductType
     * @param int $id
     * @param string $keywords
     * @param string $masterSku
     * @param string $name
     * @param int $noDiscount
     * @param int $onHandInv
     * @param int $orderQty
     * @param float $overallLength
     * @param \StructType\PriceData $priceData
     * @param string $productImage
     * @param string $productName
     * @param string $productType
     * @param string $rootSku
     * @param string $shortDescription
     * @param string $sku
     * @param int $sortOrder
     * @param string $translatedSku
     * @param string $type
     * @param int $udInd
     * @param int $userId
     * @param \StructType\ExternalUser[] $users
     */
    public function __construct($additionalFee = null, $additionalFeeDiscounted = null, $availableInd = null, $backOrderInv = null, $backorderDate = null, \StructType\ComplexDescription $complexDescription = null, $description = null, array $externalProductAttributeGroups = array(), array $externalProductAttributes = array(), array $externalProductGroups = array(), \StructType\ExternalProductType $externalProductType = null, $id = null, $keywords = null, $masterSku = null, $name = null, $noDiscount = null, $onHandInv = null, $orderQty = null, $overallLength = null, \StructType\PriceData $priceData = null, $productImage = null, $productName = null, $productType = null, $rootSku = null, $shortDescription = null, $sku = null, $sortOrder = null, $translatedSku = null, $type = null, $udInd = null, $userId = null, array $users = array())
    {
        $this
            ->setAdditionalFee($additionalFee)
            ->setAdditionalFeeDiscounted($additionalFeeDiscounted)
            ->setAvailableInd($availableInd)
            ->setBackOrderInv($backOrderInv)
            ->setBackorderDate($backorderDate)
            ->setComplexDescription($complexDescription)
            ->setDescription($description)
            ->setExternalProductAttributeGroups($externalProductAttributeGroups)
            ->setExternalProductAttributes($externalProductAttributes)
            ->setExternalProductGroups($externalProductGroups)
            ->setExternalProductType($externalProductType)
            ->setId($id)
            ->setKeywords($keywords)
            ->setMasterSku($masterSku)
            ->setName($name)
            ->setNoDiscount($noDiscount)
            ->setOnHandInv($onHandInv)
            ->setOrderQty($orderQty)
            ->setOverallLength($overallLength)
            ->setPriceData($priceData)
            ->setProductImage($productImage)
            ->setProductName($productName)
            ->setProductType($productType)
            ->setRootSku($rootSku)
            ->setShortDescription($shortDescription)
            ->setSku($sku)
            ->setSortOrder($sortOrder)
            ->setTranslatedSku($translatedSku)
            ->setType($type)
            ->setUdInd($udInd)
            ->setUserId($userId)
            ->setUsers($users);
    }
    /**
     * Get additionalFee value
     * @return float|null
     */
    public function getAdditionalFee()
    {
        return $this->additionalFee;
    }
    /**
     * Set additionalFee value
     * @param float $additionalFee
     * @return \StructType\ExternalProduct
     */
    public function setAdditionalFee($additionalFee = null)
    {
        $this->additionalFee = $additionalFee;
        return $this;
    }
    /**
     * Get additionalFeeDiscounted value
     * @return float|null
     */
    public function getAdditionalFeeDiscounted()
    {
        return $this->additionalFeeDiscounted;
    }
    /**
     * Set additionalFeeDiscounted value
     * @param float $additionalFeeDiscounted
     * @return \StructType\ExternalProduct
     */
    public function setAdditionalFeeDiscounted($additionalFeeDiscounted = null)
    {
        $this->additionalFeeDiscounted = $additionalFeeDiscounted;
        return $this;
    }
    /**
     * Get availableInd value
     * @return int|null
     */
    public function getAvailableInd()
    {
        return $this->availableInd;
    }
    /**
     * Set availableInd value
     * @param int $availableInd
     * @return \StructType\ExternalProduct
     */
    public function setAvailableInd($availableInd = null)
    {
        // validation for constraint: int
        if (!is_null($availableInd) && !is_numeric($availableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableInd)), __LINE__);
        }
        $this->availableInd = $availableInd;
        return $this;
    }
    /**
     * Get backOrderInv value
     * @return int|null
     */
    public function getBackOrderInv()
    {
        return $this->backOrderInv;
    }
    /**
     * Set backOrderInv value
     * @param int $backOrderInv
     * @return \StructType\ExternalProduct
     */
    public function setBackOrderInv($backOrderInv = null)
    {
        // validation for constraint: int
        if (!is_null($backOrderInv) && !is_numeric($backOrderInv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($backOrderInv)), __LINE__);
        }
        $this->backOrderInv = $backOrderInv;
        return $this;
    }
    /**
     * Get backorderDate value
     * @return string|null
     */
    public function getBackorderDate()
    {
        return $this->backorderDate;
    }
    /**
     * Set backorderDate value
     * @param string $backorderDate
     * @return \StructType\ExternalProduct
     */
    public function setBackorderDate($backorderDate = null)
    {
        // validation for constraint: string
        if (!is_null($backorderDate) && !is_string($backorderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backorderDate)), __LINE__);
        }
        $this->backorderDate = $backorderDate;
        return $this;
    }
    /**
     * Get complexDescription value
     * @return \StructType\ComplexDescription|null
     */
    public function getComplexDescription()
    {
        return $this->complexDescription;
    }
    /**
     * Set complexDescription value
     * @param \StructType\ComplexDescription $complexDescription
     * @return \StructType\ExternalProduct
     */
    public function setComplexDescription(\StructType\ComplexDescription $complexDescription = null)
    {
        $this->complexDescription = $complexDescription;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExternalProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get externalProductAttributeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProductAttributeGroup[]|null
     */
    public function getExternalProductAttributeGroups()
    {
        return isset($this->externalProductAttributeGroups) ? $this->externalProductAttributeGroups : null;
    }
    /**
     * Set externalProductAttributeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttributeGroup[] $externalProductAttributeGroups
     * @return \StructType\ExternalProduct
     */
    public function setExternalProductAttributeGroups(array $externalProductAttributeGroups = array())
    {
        foreach ($externalProductAttributeGroups as $externalProductExternalProductAttributeGroupsItem) {
            // validation for constraint: itemType
            if (!$externalProductExternalProductAttributeGroupsItem instanceof \StructType\ExternalProductAttributeGroup) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttributeGroups property can only contain items of \StructType\ExternalProductAttributeGroup, "%s" given', is_object($externalProductExternalProductAttributeGroupsItem) ? get_class($externalProductExternalProductAttributeGroupsItem) : gettype($externalProductExternalProductAttributeGroupsItem)), __LINE__);
            }
        }
        if (is_null($externalProductAttributeGroups) || (is_array($externalProductAttributeGroups) && empty($externalProductAttributeGroups))) {
            unset($this->externalProductAttributeGroups);
        } else {
            $this->externalProductAttributeGroups = $externalProductAttributeGroups;
        }
        return $this;
    }
    /**
     * Add item to externalProductAttributeGroups value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttributeGroup $item
     * @return \StructType\ExternalProduct
     */
    public function addToExternalProductAttributeGroups(\StructType\ExternalProductAttributeGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductAttributeGroup) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttributeGroups property can only contain items of \StructType\ExternalProductAttributeGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttributeGroups[] = $item;
        return $this;
    }
    /**
     * Get externalProductAttributes value
     * @return \StructType\ExternalProductAttribute[]|null
     */
    public function getExternalProductAttributes()
    {
        return $this->externalProductAttributes;
    }
    /**
     * Set externalProductAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute[] $externalProductAttributes
     * @return \StructType\ExternalProduct
     */
    public function setExternalProductAttributes(array $externalProductAttributes = array())
    {
        foreach ($externalProductAttributes as $externalProductExternalProductAttributesItem) {
            // validation for constraint: itemType
            if (!$externalProductExternalProductAttributesItem instanceof \StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($externalProductExternalProductAttributesItem) ? get_class($externalProductExternalProductAttributesItem) : gettype($externalProductExternalProductAttributesItem)), __LINE__);
            }
        }
        $this->externalProductAttributes = $externalProductAttributes;
        return $this;
    }
    /**
     * Add item to externalProductAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductAttribute $item
     * @return \StructType\ExternalProduct
     */
    public function addToExternalProductAttributes(\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttributes[] = $item;
        return $this;
    }
    /**
     * Get externalProductGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalProductGroup[]|null
     */
    public function getExternalProductGroups()
    {
        return isset($this->externalProductGroups) ? $this->externalProductGroups : null;
    }
    /**
     * Set externalProductGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductGroup[] $externalProductGroups
     * @return \StructType\ExternalProduct
     */
    public function setExternalProductGroups(array $externalProductGroups = array())
    {
        foreach ($externalProductGroups as $externalProductExternalProductGroupsItem) {
            // validation for constraint: itemType
            if (!$externalProductExternalProductGroupsItem instanceof \StructType\ExternalProductGroup) {
                throw new \InvalidArgumentException(sprintf('The externalProductGroups property can only contain items of \StructType\ExternalProductGroup, "%s" given', is_object($externalProductExternalProductGroupsItem) ? get_class($externalProductExternalProductGroupsItem) : gettype($externalProductExternalProductGroupsItem)), __LINE__);
            }
        }
        if (is_null($externalProductGroups) || (is_array($externalProductGroups) && empty($externalProductGroups))) {
            unset($this->externalProductGroups);
        } else {
            $this->externalProductGroups = $externalProductGroups;
        }
        return $this;
    }
    /**
     * Add item to externalProductGroups value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProductGroup $item
     * @return \StructType\ExternalProduct
     */
    public function addToExternalProductGroups(\StructType\ExternalProductGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProductGroup) {
            throw new \InvalidArgumentException(sprintf('The externalProductGroups property can only contain items of \StructType\ExternalProductGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductGroups[] = $item;
        return $this;
    }
    /**
     * Get externalProductType value
     * @return \StructType\ExternalProductType|null
     */
    public function getExternalProductType()
    {
        return $this->externalProductType;
    }
    /**
     * Set externalProductType value
     * @param \StructType\ExternalProductType $externalProductType
     * @return \StructType\ExternalProduct
     */
    public function setExternalProductType(\StructType\ExternalProductType $externalProductType = null)
    {
        $this->externalProductType = $externalProductType;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ExternalProduct
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get keywords value
     * @return string|null
     */
    public function getKeywords()
    {
        return $this->keywords;
    }
    /**
     * Set keywords value
     * @param string $keywords
     * @return \StructType\ExternalProduct
     */
    public function setKeywords($keywords = null)
    {
        // validation for constraint: string
        if (!is_null($keywords) && !is_string($keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keywords)), __LINE__);
        }
        $this->keywords = $keywords;
        return $this;
    }
    /**
     * Get masterSku value
     * @return string|null
     */
    public function getMasterSku()
    {
        return $this->masterSku;
    }
    /**
     * Set masterSku value
     * @param string $masterSku
     * @return \StructType\ExternalProduct
     */
    public function setMasterSku($masterSku = null)
    {
        // validation for constraint: string
        if (!is_null($masterSku) && !is_string($masterSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($masterSku)), __LINE__);
        }
        $this->masterSku = $masterSku;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ExternalProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get noDiscount value
     * @return int|null
     */
    public function getNoDiscount()
    {
        return $this->noDiscount;
    }
    /**
     * Set noDiscount value
     * @param int $noDiscount
     * @return \StructType\ExternalProduct
     */
    public function setNoDiscount($noDiscount = null)
    {
        // validation for constraint: int
        if (!is_null($noDiscount) && !is_numeric($noDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noDiscount)), __LINE__);
        }
        $this->noDiscount = $noDiscount;
        return $this;
    }
    /**
     * Get onHandInv value
     * @return int|null
     */
    public function getOnHandInv()
    {
        return $this->onHandInv;
    }
    /**
     * Set onHandInv value
     * @param int $onHandInv
     * @return \StructType\ExternalProduct
     */
    public function setOnHandInv($onHandInv = null)
    {
        // validation for constraint: int
        if (!is_null($onHandInv) && !is_numeric($onHandInv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onHandInv)), __LINE__);
        }
        $this->onHandInv = $onHandInv;
        return $this;
    }
    /**
     * Get orderQty value
     * @return int|null
     */
    public function getOrderQty()
    {
        return $this->orderQty;
    }
    /**
     * Set orderQty value
     * @param int $orderQty
     * @return \StructType\ExternalProduct
     */
    public function setOrderQty($orderQty = null)
    {
        // validation for constraint: int
        if (!is_null($orderQty) && !is_numeric($orderQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderQty)), __LINE__);
        }
        $this->orderQty = $orderQty;
        return $this;
    }
    /**
     * Get overallLength value
     * @return float|null
     */
    public function getOverallLength()
    {
        return $this->overallLength;
    }
    /**
     * Set overallLength value
     * @param float $overallLength
     * @return \StructType\ExternalProduct
     */
    public function setOverallLength($overallLength = null)
    {
        $this->overallLength = $overallLength;
        return $this;
    }
    /**
     * Get priceData value
     * @return \StructType\PriceData|null
     */
    public function getPriceData()
    {
        return $this->priceData;
    }
    /**
     * Set priceData value
     * @param \StructType\PriceData $priceData
     * @return \StructType\ExternalProduct
     */
    public function setPriceData(\StructType\PriceData $priceData = null)
    {
        $this->priceData = $priceData;
        return $this;
    }
    /**
     * Get productImage value
     * @return string|null
     */
    public function getProductImage()
    {
        return $this->productImage;
    }
    /**
     * Set productImage value
     * @param string $productImage
     * @return \StructType\ExternalProduct
     */
    public function setProductImage($productImage = null)
    {
        // validation for constraint: string
        if (!is_null($productImage) && !is_string($productImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productImage)), __LINE__);
        }
        $this->productImage = $productImage;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\ExternalProduct
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\ExternalProduct
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get rootSku value
     * @return string|null
     */
    public function getRootSku()
    {
        return $this->rootSku;
    }
    /**
     * Set rootSku value
     * @param string $rootSku
     * @return \StructType\ExternalProduct
     */
    public function setRootSku($rootSku = null)
    {
        // validation for constraint: string
        if (!is_null($rootSku) && !is_string($rootSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rootSku)), __LINE__);
        }
        $this->rootSku = $rootSku;
        return $this;
    }
    /**
     * Get shortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }
    /**
     * Set shortDescription value
     * @param string $shortDescription
     * @return \StructType\ExternalProduct
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortDescription)), __LINE__);
        }
        $this->shortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \StructType\ExternalProduct
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param int $sortOrder
     * @return \StructType\ExternalProduct
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get translatedSku value
     * @return string|null
     */
    public function getTranslatedSku()
    {
        return $this->translatedSku;
    }
    /**
     * Set translatedSku value
     * @param string $translatedSku
     * @return \StructType\ExternalProduct
     */
    public function setTranslatedSku($translatedSku = null)
    {
        // validation for constraint: string
        if (!is_null($translatedSku) && !is_string($translatedSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($translatedSku)), __LINE__);
        }
        $this->translatedSku = $translatedSku;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ExternalProduct
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get udInd value
     * @return int|null
     */
    public function getUdInd()
    {
        return $this->udInd;
    }
    /**
     * Set udInd value
     * @param int $udInd
     * @return \StructType\ExternalProduct
     */
    public function setUdInd($udInd = null)
    {
        // validation for constraint: int
        if (!is_null($udInd) && !is_numeric($udInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($udInd)), __LINE__);
        }
        $this->udInd = $udInd;
        return $this;
    }
    /**
     * Get userId value
     * @return int|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param int $userId
     * @return \StructType\ExternalProduct
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalUser[]|null
     */
    public function getUsers()
    {
        return isset($this->users) ? $this->users : null;
    }
    /**
     * Set users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalUser[] $users
     * @return \StructType\ExternalProduct
     */
    public function setUsers(array $users = array())
    {
        foreach ($users as $externalProductUsersItem) {
            // validation for constraint: itemType
            if (!$externalProductUsersItem instanceof \StructType\ExternalUser) {
                throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\ExternalUser, "%s" given', is_object($externalProductUsersItem) ? get_class($externalProductUsersItem) : gettype($externalProductUsersItem)), __LINE__);
            }
        }
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->users);
        } else {
            $this->users = $users;
        }
        return $this;
    }
    /**
     * Add item to users value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalUser $item
     * @return \StructType\ExternalProduct
     */
    public function addToUsers(\StructType\ExternalUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalUser) {
            throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\ExternalUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->users[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
