<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalOrder StructType
 * @subpackage Structs
 */
class ExternalOrder extends AbstractStructBase
{
    /**
     * The channelOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChannelOrderId[]
     */
    public $channelOrderId;
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Channel[]
     */
    public $channel;
    /**
     * The costData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CostData
     */
    public $costData;
    /**
     * The couponCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $couponCode;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalCustomer
     */
    public $customer;
    /**
     * The externalOrderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalOrderId;
    /**
     * The giftCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GiftCard
     */
    public $giftCard;
    /**
     * The giftData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GiftData
     */
    public $giftData;
    /**
     * The insuranceFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insuranceFee;
    /**
     * The lineItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalOrderLineItem[]
     */
    public $lineItems;
    /**
     * The orderTags
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $orderTags;
    /**
     * The orderTakenBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderTakenBy;
    /**
     * The pageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageId;
    /**
     * The promoCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $promoCode;
    /**
     * The shippingData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShippingData
     */
    public $shippingData;
    /**
     * The sourceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceCode;
    /**
     * Constructor method for externalOrder
     * @uses ExternalOrder::setChannelOrderId()
     * @uses ExternalOrder::setChannel()
     * @uses ExternalOrder::setCostData()
     * @uses ExternalOrder::setCouponCode()
     * @uses ExternalOrder::setCustomer()
     * @uses ExternalOrder::setExternalOrderId()
     * @uses ExternalOrder::setGiftCard()
     * @uses ExternalOrder::setGiftData()
     * @uses ExternalOrder::setInsuranceFee()
     * @uses ExternalOrder::setLineItems()
     * @uses ExternalOrder::setOrderTags()
     * @uses ExternalOrder::setOrderTakenBy()
     * @uses ExternalOrder::setPageId()
     * @uses ExternalOrder::setPromoCode()
     * @uses ExternalOrder::setShippingData()
     * @uses ExternalOrder::setSourceCode()
     * @param \StructType\ChannelOrderId[] $channelOrderId
     * @param \StructType\Channel[] $channel
     * @param \StructType\CostData $costData
     * @param string $couponCode
     * @param \StructType\ExternalCustomer $customer
     * @param int $externalOrderId
     * @param \StructType\GiftCard $giftCard
     * @param \StructType\GiftData $giftData
     * @param float $insuranceFee
     * @param \StructType\ExternalOrderLineItem[] $lineItems
     * @param string[] $orderTags
     * @param string $orderTakenBy
     * @param string $pageId
     * @param string $promoCode
     * @param \StructType\ShippingData $shippingData
     * @param string $sourceCode
     */
    public function __construct(array $channelOrderId = array(), array $channel = array(), \StructType\CostData $costData = null, $couponCode = null, \StructType\ExternalCustomer $customer = null, $externalOrderId = null, \StructType\GiftCard $giftCard = null, \StructType\GiftData $giftData = null, $insuranceFee = null, array $lineItems = array(), array $orderTags = array(), $orderTakenBy = null, $pageId = null, $promoCode = null, \StructType\ShippingData $shippingData = null, $sourceCode = null)
    {
        $this
            ->setChannelOrderId($channelOrderId)
            ->setChannel($channel)
            ->setCostData($costData)
            ->setCouponCode($couponCode)
            ->setCustomer($customer)
            ->setExternalOrderId($externalOrderId)
            ->setGiftCard($giftCard)
            ->setGiftData($giftData)
            ->setInsuranceFee($insuranceFee)
            ->setLineItems($lineItems)
            ->setOrderTags($orderTags)
            ->setOrderTakenBy($orderTakenBy)
            ->setPageId($pageId)
            ->setPromoCode($promoCode)
            ->setShippingData($shippingData)
            ->setSourceCode($sourceCode);
    }
    /**
     * Get channelOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChannelOrderId[]|null
     */
    public function getChannelOrderId()
    {
        return isset($this->channelOrderId) ? $this->channelOrderId : null;
    }
    /**
     * Set channelOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChannelOrderId[] $channelOrderId
     * @return \StructType\ExternalOrder
     */
    public function setChannelOrderId(array $channelOrderId = array())
    {
        foreach ($channelOrderId as $externalOrderChannelOrderIdItem) {
            // validation for constraint: itemType
            if (!$externalOrderChannelOrderIdItem instanceof \StructType\ChannelOrderId) {
                throw new \InvalidArgumentException(sprintf('The channelOrderId property can only contain items of \StructType\ChannelOrderId, "%s" given', is_object($externalOrderChannelOrderIdItem) ? get_class($externalOrderChannelOrderIdItem) : gettype($externalOrderChannelOrderIdItem)), __LINE__);
            }
        }
        if (is_null($channelOrderId) || (is_array($channelOrderId) && empty($channelOrderId))) {
            unset($this->channelOrderId);
        } else {
            $this->channelOrderId = $channelOrderId;
        }
        return $this;
    }
    /**
     * Add item to channelOrderId value
     * @throws \InvalidArgumentException
     * @param \StructType\ChannelOrderId $item
     * @return \StructType\ExternalOrder
     */
    public function addToChannelOrderId(\StructType\ChannelOrderId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChannelOrderId) {
            throw new \InvalidArgumentException(sprintf('The channelOrderId property can only contain items of \StructType\ChannelOrderId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->channelOrderId[] = $item;
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Channel[]|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Channel[] $channel
     * @return \StructType\ExternalOrder
     */
    public function setChannel(array $channel = array())
    {
        foreach ($channel as $externalOrderChannelItem) {
            // validation for constraint: itemType
            if (!$externalOrderChannelItem instanceof \StructType\Channel) {
                throw new \InvalidArgumentException(sprintf('The channel property can only contain items of \StructType\Channel, "%s" given', is_object($externalOrderChannelItem) ? get_class($externalOrderChannelItem) : gettype($externalOrderChannelItem)), __LINE__);
            }
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Add item to channel value
     * @throws \InvalidArgumentException
     * @param \StructType\Channel $item
     * @return \StructType\ExternalOrder
     */
    public function addToChannel(\StructType\Channel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Channel) {
            throw new \InvalidArgumentException(sprintf('The channel property can only contain items of \StructType\Channel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->channel[] = $item;
        return $this;
    }
    /**
     * Get costData value
     * @return \StructType\CostData|null
     */
    public function getCostData()
    {
        return $this->costData;
    }
    /**
     * Set costData value
     * @param \StructType\CostData $costData
     * @return \StructType\ExternalOrder
     */
    public function setCostData(\StructType\CostData $costData = null)
    {
        $this->costData = $costData;
        return $this;
    }
    /**
     * Get couponCode value
     * @return string|null
     */
    public function getCouponCode()
    {
        return $this->couponCode;
    }
    /**
     * Set couponCode value
     * @param string $couponCode
     * @return \StructType\ExternalOrder
     */
    public function setCouponCode($couponCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponCode) && !is_string($couponCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponCode)), __LINE__);
        }
        $this->couponCode = $couponCode;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\ExternalCustomer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\ExternalCustomer $customer
     * @return \StructType\ExternalOrder
     */
    public function setCustomer(\StructType\ExternalCustomer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get externalOrderId value
     * @return int|null
     */
    public function getExternalOrderId()
    {
        return $this->externalOrderId;
    }
    /**
     * Set externalOrderId value
     * @param int $externalOrderId
     * @return \StructType\ExternalOrder
     */
    public function setExternalOrderId($externalOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($externalOrderId) && !is_numeric($externalOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalOrderId)), __LINE__);
        }
        $this->externalOrderId = $externalOrderId;
        return $this;
    }
    /**
     * Get giftCard value
     * @return \StructType\GiftCard|null
     */
    public function getGiftCard()
    {
        return $this->giftCard;
    }
    /**
     * Set giftCard value
     * @param \StructType\GiftCard $giftCard
     * @return \StructType\ExternalOrder
     */
    public function setGiftCard(\StructType\GiftCard $giftCard = null)
    {
        $this->giftCard = $giftCard;
        return $this;
    }
    /**
     * Get giftData value
     * @return \StructType\GiftData|null
     */
    public function getGiftData()
    {
        return $this->giftData;
    }
    /**
     * Set giftData value
     * @param \StructType\GiftData $giftData
     * @return \StructType\ExternalOrder
     */
    public function setGiftData(\StructType\GiftData $giftData = null)
    {
        $this->giftData = $giftData;
        return $this;
    }
    /**
     * Get insuranceFee value
     * @return float|null
     */
    public function getInsuranceFee()
    {
        return $this->insuranceFee;
    }
    /**
     * Set insuranceFee value
     * @param float $insuranceFee
     * @return \StructType\ExternalOrder
     */
    public function setInsuranceFee($insuranceFee = null)
    {
        $this->insuranceFee = $insuranceFee;
        return $this;
    }
    /**
     * Get lineItems value
     * @return \StructType\ExternalOrderLineItem[]|null
     */
    public function getLineItems()
    {
        return $this->lineItems;
    }
    /**
     * Set lineItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalOrderLineItem[] $lineItems
     * @return \StructType\ExternalOrder
     */
    public function setLineItems(array $lineItems = array())
    {
        foreach ($lineItems as $externalOrderLineItemsItem) {
            // validation for constraint: itemType
            if (!$externalOrderLineItemsItem instanceof \StructType\ExternalOrderLineItem) {
                throw new \InvalidArgumentException(sprintf('The lineItems property can only contain items of \StructType\ExternalOrderLineItem, "%s" given', is_object($externalOrderLineItemsItem) ? get_class($externalOrderLineItemsItem) : gettype($externalOrderLineItemsItem)), __LINE__);
            }
        }
        $this->lineItems = $lineItems;
        return $this;
    }
    /**
     * Add item to lineItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalOrderLineItem $item
     * @return \StructType\ExternalOrder
     */
    public function addToLineItems(\StructType\ExternalOrderLineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalOrderLineItem) {
            throw new \InvalidArgumentException(sprintf('The lineItems property can only contain items of \StructType\ExternalOrderLineItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lineItems[] = $item;
        return $this;
    }
    /**
     * Get orderTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrderTags()
    {
        return isset($this->orderTags) ? $this->orderTags : null;
    }
    /**
     * Set orderTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $orderTags
     * @return \StructType\ExternalOrder
     */
    public function setOrderTags(array $orderTags = array())
    {
        foreach ($orderTags as $externalOrderOrderTagsItem) {
            // validation for constraint: itemType
            if (!is_string($externalOrderOrderTagsItem)) {
                throw new \InvalidArgumentException(sprintf('The orderTags property can only contain items of string, "%s" given', is_object($externalOrderOrderTagsItem) ? get_class($externalOrderOrderTagsItem) : gettype($externalOrderOrderTagsItem)), __LINE__);
            }
        }
        if (is_null($orderTags) || (is_array($orderTags) && empty($orderTags))) {
            unset($this->orderTags);
        } else {
            $this->orderTags = $orderTags;
        }
        return $this;
    }
    /**
     * Add item to orderTags value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExternalOrder
     */
    public function addToOrderTags($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orderTags property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderTags[] = $item;
        return $this;
    }
    /**
     * Get orderTakenBy value
     * @return string|null
     */
    public function getOrderTakenBy()
    {
        return $this->orderTakenBy;
    }
    /**
     * Set orderTakenBy value
     * @param string $orderTakenBy
     * @return \StructType\ExternalOrder
     */
    public function setOrderTakenBy($orderTakenBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderTakenBy) && !is_string($orderTakenBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTakenBy)), __LINE__);
        }
        $this->orderTakenBy = $orderTakenBy;
        return $this;
    }
    /**
     * Get pageId value
     * @return string|null
     */
    public function getPageId()
    {
        return $this->pageId;
    }
    /**
     * Set pageId value
     * @param string $pageId
     * @return \StructType\ExternalOrder
     */
    public function setPageId($pageId = null)
    {
        // validation for constraint: string
        if (!is_null($pageId) && !is_string($pageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageId)), __LINE__);
        }
        $this->pageId = $pageId;
        return $this;
    }
    /**
     * Get promoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param string $promoCode
     * @return \StructType\ExternalOrder
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promoCode)), __LINE__);
        }
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get shippingData value
     * @return \StructType\ShippingData|null
     */
    public function getShippingData()
    {
        return $this->shippingData;
    }
    /**
     * Set shippingData value
     * @param \StructType\ShippingData $shippingData
     * @return \StructType\ExternalOrder
     */
    public function setShippingData(\StructType\ShippingData $shippingData = null)
    {
        $this->shippingData = $shippingData;
        return $this;
    }
    /**
     * Get sourceCode value
     * @return string|null
     */
    public function getSourceCode()
    {
        return $this->sourceCode;
    }
    /**
     * Set sourceCode value
     * @param string $sourceCode
     * @return \StructType\ExternalOrder
     */
    public function setSourceCode($sourceCode = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCode) && !is_string($sourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceCode)), __LINE__);
        }
        $this->sourceCode = $sourceCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
