<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalAddress StructType
 * @subpackage Structs
 */
class ExternalAddress extends AbstractStructBase
{
    /**
     * The activeInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $activeInd;
    /**
     * The addressName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressName;
    /**
     * The addressType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressType;
    /**
     * The cellPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cellPhone;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The homePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homePhone;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The streetNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetNumber;
    /**
     * The streetPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetPrefix;
    /**
     * The streetSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetSuffix;
    /**
     * The streetTwo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetTwo;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $suffix;
    /**
     * The workPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $workPhone;
    /**
     * The zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * Constructor method for externalAddress
     * @uses ExternalAddress::setActiveInd()
     * @uses ExternalAddress::setAddressName()
     * @uses ExternalAddress::setAddressType()
     * @uses ExternalAddress::setCellPhone()
     * @uses ExternalAddress::setCity()
     * @uses ExternalAddress::setCompany()
     * @uses ExternalAddress::setCountry()
     * @uses ExternalAddress::setEmail()
     * @uses ExternalAddress::setFirstName()
     * @uses ExternalAddress::setHomePhone()
     * @uses ExternalAddress::setId()
     * @uses ExternalAddress::setLastName()
     * @uses ExternalAddress::setPrefix()
     * @uses ExternalAddress::setState()
     * @uses ExternalAddress::setStreet()
     * @uses ExternalAddress::setStreetNumber()
     * @uses ExternalAddress::setStreetPrefix()
     * @uses ExternalAddress::setStreetSuffix()
     * @uses ExternalAddress::setStreetTwo()
     * @uses ExternalAddress::setSuffix()
     * @uses ExternalAddress::setWorkPhone()
     * @uses ExternalAddress::setZip()
     * @param int $activeInd
     * @param string $addressName
     * @param string $addressType
     * @param string $cellPhone
     * @param string $city
     * @param string $company
     * @param string $country
     * @param string $email
     * @param string $firstName
     * @param string $homePhone
     * @param int $id
     * @param string $lastName
     * @param string $prefix
     * @param string $state
     * @param string $street
     * @param string $streetNumber
     * @param string $streetPrefix
     * @param string $streetSuffix
     * @param string $streetTwo
     * @param string $suffix
     * @param string $workPhone
     * @param string $zip
     */
    public function __construct($activeInd = null, $addressName = null, $addressType = null, $cellPhone = null, $city = null, $company = null, $country = null, $email = null, $firstName = null, $homePhone = null, $id = null, $lastName = null, $prefix = null, $state = null, $street = null, $streetNumber = null, $streetPrefix = null, $streetSuffix = null, $streetTwo = null, $suffix = null, $workPhone = null, $zip = null)
    {
        $this
            ->setActiveInd($activeInd)
            ->setAddressName($addressName)
            ->setAddressType($addressType)
            ->setCellPhone($cellPhone)
            ->setCity($city)
            ->setCompany($company)
            ->setCountry($country)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setHomePhone($homePhone)
            ->setId($id)
            ->setLastName($lastName)
            ->setPrefix($prefix)
            ->setState($state)
            ->setStreet($street)
            ->setStreetNumber($streetNumber)
            ->setStreetPrefix($streetPrefix)
            ->setStreetSuffix($streetSuffix)
            ->setStreetTwo($streetTwo)
            ->setSuffix($suffix)
            ->setWorkPhone($workPhone)
            ->setZip($zip);
    }
    /**
     * Get activeInd value
     * @return int|null
     */
    public function getActiveInd()
    {
        return $this->activeInd;
    }
    /**
     * Set activeInd value
     * @param int $activeInd
     * @return \StructType\ExternalAddress
     */
    public function setActiveInd($activeInd = null)
    {
        // validation for constraint: int
        if (!is_null($activeInd) && !is_numeric($activeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeInd)), __LINE__);
        }
        $this->activeInd = $activeInd;
        return $this;
    }
    /**
     * Get addressName value
     * @return string|null
     */
    public function getAddressName()
    {
        return $this->addressName;
    }
    /**
     * Set addressName value
     * @param string $addressName
     * @return \StructType\ExternalAddress
     */
    public function setAddressName($addressName = null)
    {
        // validation for constraint: string
        if (!is_null($addressName) && !is_string($addressName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressName)), __LINE__);
        }
        $this->addressName = $addressName;
        return $this;
    }
    /**
     * Get addressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->addressType;
    }
    /**
     * Set addressType value
     * @uses \EnumType\AddressTypes::valueIsValid()
     * @uses \EnumType\AddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressType
     * @return \StructType\ExternalAddress
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressTypes::valueIsValid($addressType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addressType, implode(', ', \EnumType\AddressTypes::getValidValues())), __LINE__);
        }
        $this->addressType = $addressType;
        return $this;
    }
    /**
     * Get cellPhone value
     * @return string|null
     */
    public function getCellPhone()
    {
        return $this->cellPhone;
    }
    /**
     * Set cellPhone value
     * @param string $cellPhone
     * @return \StructType\ExternalAddress
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellPhone)), __LINE__);
        }
        $this->cellPhone = $cellPhone;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\ExternalAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \StructType\ExternalAddress
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\ExternalAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ExternalAddress
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\ExternalAddress
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get homePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->homePhone;
    }
    /**
     * Set homePhone value
     * @param string $homePhone
     * @return \StructType\ExternalAddress
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        $this->homePhone = $homePhone;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ExternalAddress
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\ExternalAddress
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\ExternalAddress
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\ExternalAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\ExternalAddress
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get streetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }
    /**
     * Set streetNumber value
     * @param string $streetNumber
     * @return \StructType\ExternalAddress
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNumber)), __LINE__);
        }
        $this->streetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get streetPrefix value
     * @return string|null
     */
    public function getStreetPrefix()
    {
        return $this->streetPrefix;
    }
    /**
     * Set streetPrefix value
     * @param string $streetPrefix
     * @return \StructType\ExternalAddress
     */
    public function setStreetPrefix($streetPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($streetPrefix) && !is_string($streetPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetPrefix)), __LINE__);
        }
        $this->streetPrefix = $streetPrefix;
        return $this;
    }
    /**
     * Get streetSuffix value
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return $this->streetSuffix;
    }
    /**
     * Set streetSuffix value
     * @param string $streetSuffix
     * @return \StructType\ExternalAddress
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($streetSuffix) && !is_string($streetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetSuffix)), __LINE__);
        }
        $this->streetSuffix = $streetSuffix;
        return $this;
    }
    /**
     * Get streetTwo value
     * @return string|null
     */
    public function getStreetTwo()
    {
        return $this->streetTwo;
    }
    /**
     * Set streetTwo value
     * @param string $streetTwo
     * @return \StructType\ExternalAddress
     */
    public function setStreetTwo($streetTwo = null)
    {
        // validation for constraint: string
        if (!is_null($streetTwo) && !is_string($streetTwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetTwo)), __LINE__);
        }
        $this->streetTwo = $streetTwo;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \StructType\ExternalAddress
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Get workPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->workPhone;
    }
    /**
     * Set workPhone value
     * @param string $workPhone
     * @return \StructType\ExternalAddress
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPhone)), __LINE__);
        }
        $this->workPhone = $workPhone;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\ExternalAddress
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
