<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentPrintJob StructType
 * @subpackage Structs
 */
class DocumentPrintJob extends PrintJob
{
    /**
     * The affixMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $affixMethod;
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentType;
    /**
     * The replacesDefault
     * @var bool
     */
    public $replacesDefault;
    /**
     * Constructor method for documentPrintJob
     * @uses DocumentPrintJob::setAffixMethod()
     * @uses DocumentPrintJob::setDocumentType()
     * @uses DocumentPrintJob::setReplacesDefault()
     * @param string $affixMethod
     * @param string $documentType
     * @param bool $replacesDefault
     */
    public function __construct($affixMethod = null, $documentType = null, $replacesDefault = null)
    {
        $this
            ->setAffixMethod($affixMethod)
            ->setDocumentType($documentType)
            ->setReplacesDefault($replacesDefault);
    }
    /**
     * Get affixMethod value
     * @return string|null
     */
    public function getAffixMethod()
    {
        return $this->affixMethod;
    }
    /**
     * Set affixMethod value
     * @uses \EnumType\AffixMethod::valueIsValid()
     * @uses \EnumType\AffixMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $affixMethod
     * @return \StructType\DocumentPrintJob
     */
    public function setAffixMethod($affixMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AffixMethod::valueIsValid($affixMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $affixMethod, implode(', ', \EnumType\AffixMethod::getValidValues())), __LINE__);
        }
        $this->affixMethod = $affixMethod;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \EnumType\DocumentType::valueIsValid()
     * @uses \EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \StructType\DocumentPrintJob
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $documentType, implode(', ', \EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get replacesDefault value
     * @return bool|null
     */
    public function getReplacesDefault()
    {
        return $this->replacesDefault;
    }
    /**
     * Set replacesDefault value
     * @param bool $replacesDefault
     * @return \StructType\DocumentPrintJob
     */
    public function setReplacesDefault($replacesDefault = null)
    {
        $this->replacesDefault = $replacesDefault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentPrintJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
