<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dimensionedExternalProduct StructType
 * @subpackage Structs
 */
class DimensionedExternalProduct extends ExternalProduct
{
    /**
     * The dimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dimension
     */
    public $dimension;
    /**
     * The height
     * @var float
     */
    public $height;
    /**
     * The heightFraction
     * @var float
     */
    public $heightFraction;
    /**
     * The heightWhole
     * @var int
     */
    public $heightWhole;
    /**
     * The maxPurchaseSize
     * @var float
     */
    public $maxPurchaseSize;
    /**
     * The minPurchaseSize
     * @var float
     */
    public $minPurchaseSize;
    /**
     * The width
     * @var float
     */
    public $width;
    /**
     * The widthFraction
     * @var float
     */
    public $widthFraction;
    /**
     * The widthWhole
     * @var int
     */
    public $widthWhole;
    /**
     * Constructor method for dimensionedExternalProduct
     * @uses DimensionedExternalProduct::setDimension()
     * @uses DimensionedExternalProduct::setHeight()
     * @uses DimensionedExternalProduct::setHeightFraction()
     * @uses DimensionedExternalProduct::setHeightWhole()
     * @uses DimensionedExternalProduct::setMaxPurchaseSize()
     * @uses DimensionedExternalProduct::setMinPurchaseSize()
     * @uses DimensionedExternalProduct::setWidth()
     * @uses DimensionedExternalProduct::setWidthFraction()
     * @uses DimensionedExternalProduct::setWidthWhole()
     * @param \StructType\Dimension $dimension
     * @param float $height
     * @param float $heightFraction
     * @param int $heightWhole
     * @param float $maxPurchaseSize
     * @param float $minPurchaseSize
     * @param float $width
     * @param float $widthFraction
     * @param int $widthWhole
     */
    public function __construct(\StructType\Dimension $dimension = null, $height = null, $heightFraction = null, $heightWhole = null, $maxPurchaseSize = null, $minPurchaseSize = null, $width = null, $widthFraction = null, $widthWhole = null)
    {
        $this
            ->setDimension($dimension)
            ->setHeight($height)
            ->setHeightFraction($heightFraction)
            ->setHeightWhole($heightWhole)
            ->setMaxPurchaseSize($maxPurchaseSize)
            ->setMinPurchaseSize($minPurchaseSize)
            ->setWidth($width)
            ->setWidthFraction($widthFraction)
            ->setWidthWhole($widthWhole);
    }
    /**
     * Get dimension value
     * @return \StructType\Dimension|null
     */
    public function getDimension()
    {
        return $this->dimension;
    }
    /**
     * Set dimension value
     * @param \StructType\Dimension $dimension
     * @return \StructType\DimensionedExternalProduct
     */
    public function setDimension(\StructType\Dimension $dimension = null)
    {
        $this->dimension = $dimension;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \StructType\DimensionedExternalProduct
     */
    public function setHeight($height = null)
    {
        $this->height = $height;
        return $this;
    }
    /**
     * Get heightFraction value
     * @return float|null
     */
    public function getHeightFraction()
    {
        return $this->heightFraction;
    }
    /**
     * Set heightFraction value
     * @param float $heightFraction
     * @return \StructType\DimensionedExternalProduct
     */
    public function setHeightFraction($heightFraction = null)
    {
        $this->heightFraction = $heightFraction;
        return $this;
    }
    /**
     * Get heightWhole value
     * @return int|null
     */
    public function getHeightWhole()
    {
        return $this->heightWhole;
    }
    /**
     * Set heightWhole value
     * @param int $heightWhole
     * @return \StructType\DimensionedExternalProduct
     */
    public function setHeightWhole($heightWhole = null)
    {
        // validation for constraint: int
        if (!is_null($heightWhole) && !is_numeric($heightWhole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($heightWhole)), __LINE__);
        }
        $this->heightWhole = $heightWhole;
        return $this;
    }
    /**
     * Get maxPurchaseSize value
     * @return float|null
     */
    public function getMaxPurchaseSize()
    {
        return $this->maxPurchaseSize;
    }
    /**
     * Set maxPurchaseSize value
     * @param float $maxPurchaseSize
     * @return \StructType\DimensionedExternalProduct
     */
    public function setMaxPurchaseSize($maxPurchaseSize = null)
    {
        $this->maxPurchaseSize = $maxPurchaseSize;
        return $this;
    }
    /**
     * Get minPurchaseSize value
     * @return float|null
     */
    public function getMinPurchaseSize()
    {
        return $this->minPurchaseSize;
    }
    /**
     * Set minPurchaseSize value
     * @param float $minPurchaseSize
     * @return \StructType\DimensionedExternalProduct
     */
    public function setMinPurchaseSize($minPurchaseSize = null)
    {
        $this->minPurchaseSize = $minPurchaseSize;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \StructType\DimensionedExternalProduct
     */
    public function setWidth($width = null)
    {
        $this->width = $width;
        return $this;
    }
    /**
     * Get widthFraction value
     * @return float|null
     */
    public function getWidthFraction()
    {
        return $this->widthFraction;
    }
    /**
     * Set widthFraction value
     * @param float $widthFraction
     * @return \StructType\DimensionedExternalProduct
     */
    public function setWidthFraction($widthFraction = null)
    {
        $this->widthFraction = $widthFraction;
        return $this;
    }
    /**
     * Get widthWhole value
     * @return int|null
     */
    public function getWidthWhole()
    {
        return $this->widthWhole;
    }
    /**
     * Set widthWhole value
     * @param int $widthWhole
     * @return \StructType\DimensionedExternalProduct
     */
    public function setWidthWhole($widthWhole = null)
    {
        // validation for constraint: int
        if (!is_null($widthWhole) && !is_numeric($widthWhole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($widthWhole)), __LINE__);
        }
        $this->widthWhole = $widthWhole;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DimensionedExternalProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
