<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customProduct StructType
 * @subpackage Structs
 */
class CustomProduct extends ExternalProduct
{
    /**
     * The frameSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frameSku;
    /**
     * The matSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matSku;
    /**
     * Constructor method for customProduct
     * @uses CustomProduct::setFrameSku()
     * @uses CustomProduct::setMatSku()
     * @param string $frameSku
     * @param string $matSku
     */
    public function __construct($frameSku = null, $matSku = null)
    {
        $this
            ->setFrameSku($frameSku)
            ->setMatSku($matSku);
    }
    /**
     * Get frameSku value
     * @return string|null
     */
    public function getFrameSku()
    {
        return $this->frameSku;
    }
    /**
     * Set frameSku value
     * @param string $frameSku
     * @return \StructType\CustomProduct
     */
    public function setFrameSku($frameSku = null)
    {
        // validation for constraint: string
        if (!is_null($frameSku) && !is_string($frameSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frameSku)), __LINE__);
        }
        $this->frameSku = $frameSku;
        return $this;
    }
    /**
     * Get matSku value
     * @return string|null
     */
    public function getMatSku()
    {
        return $this->matSku;
    }
    /**
     * Set matSku value
     * @param string $matSku
     * @return \StructType\CustomProduct
     */
    public function setMatSku($matSku = null)
    {
        // validation for constraint: string
        if (!is_null($matSku) && !is_string($matSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($matSku)), __LINE__);
        }
        $this->matSku = $matSku;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
