<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for creditCard StructType
 * @subpackage Structs
 */
class CreditCard extends PaymentMethod
{
    /**
     * The billingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalAddress
     */
    public $billingAddress;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardType;
    /**
     * The ccvNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ccvNumber;
    /**
     * The expirationDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expirationDay;
    /**
     * The expirationMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expirationMonth;
    /**
     * The expirationYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expirationYear;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * Constructor method for creditCard
     * @uses CreditCard::setBillingAddress()
     * @uses CreditCard::setCardType()
     * @uses CreditCard::setCcvNumber()
     * @uses CreditCard::setExpirationDay()
     * @uses CreditCard::setExpirationMonth()
     * @uses CreditCard::setExpirationYear()
     * @uses CreditCard::setNumber()
     * @param \StructType\ExternalAddress $billingAddress
     * @param string $cardType
     * @param int $ccvNumber
     * @param int $expirationDay
     * @param int $expirationMonth
     * @param int $expirationYear
     * @param string $number
     */
    public function __construct(\StructType\ExternalAddress $billingAddress = null, $cardType = null, $ccvNumber = null, $expirationDay = null, $expirationMonth = null, $expirationYear = null, $number = null)
    {
        $this
            ->setBillingAddress($billingAddress)
            ->setCardType($cardType)
            ->setCcvNumber($ccvNumber)
            ->setExpirationDay($expirationDay)
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setNumber($number);
    }
    /**
     * Get billingAddress value
     * @return \StructType\ExternalAddress|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\ExternalAddress $billingAddress
     * @return \StructType\CreditCard
     */
    public function setBillingAddress(\StructType\ExternalAddress $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @uses \EnumType\CardType::valueIsValid()
     * @uses \EnumType\CardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \StructType\CreditCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CardType::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cardType, implode(', ', \EnumType\CardType::getValidValues())), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get ccvNumber value
     * @return int|null
     */
    public function getCcvNumber()
    {
        return $this->ccvNumber;
    }
    /**
     * Set ccvNumber value
     * @param int $ccvNumber
     * @return \StructType\CreditCard
     */
    public function setCcvNumber($ccvNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ccvNumber) && !is_numeric($ccvNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccvNumber)), __LINE__);
        }
        $this->ccvNumber = $ccvNumber;
        return $this;
    }
    /**
     * Get expirationDay value
     * @return int|null
     */
    public function getExpirationDay()
    {
        return $this->expirationDay;
    }
    /**
     * Set expirationDay value
     * @param int $expirationDay
     * @return \StructType\CreditCard
     */
    public function setExpirationDay($expirationDay = null)
    {
        // validation for constraint: int
        if (!is_null($expirationDay) && !is_numeric($expirationDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationDay)), __LINE__);
        }
        $this->expirationDay = $expirationDay;
        return $this;
    }
    /**
     * Get expirationMonth value
     * @return int|null
     */
    public function getExpirationMonth()
    {
        return $this->expirationMonth;
    }
    /**
     * Set expirationMonth value
     * @param int $expirationMonth
     * @return \StructType\CreditCard
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expirationMonth) && !is_numeric($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationMonth)), __LINE__);
        }
        $this->expirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get expirationYear value
     * @return int|null
     */
    public function getExpirationYear()
    {
        return $this->expirationYear;
    }
    /**
     * Set expirationYear value
     * @param int $expirationYear
     * @return \StructType\CreditCard
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: int
        if (!is_null($expirationYear) && !is_numeric($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationYear)), __LINE__);
        }
        $this->expirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\CreditCard
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
