<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for collection StructType
 * @subpackage Structs
 */
class Collection extends ExternalProduct
{
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalProduct[]
     */
    public $products;
    /**
     * The skus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $skus;
    /**
     * Constructor method for collection
     * @uses Collection::setProducts()
     * @uses Collection::setSkus()
     * @param \StructType\ExternalProduct[] $products
     * @param string[] $skus
     */
    public function __construct(array $products = array(), array $skus = array())
    {
        $this
            ->setProducts($products)
            ->setSkus($skus);
    }
    /**
     * Get products value
     * @return \StructType\ExternalProduct[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProduct[] $products
     * @return \StructType\Collection
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $collectionProductsItem) {
            // validation for constraint: itemType
            if (!$collectionProductsItem instanceof \StructType\ExternalProduct) {
                throw new \InvalidArgumentException(sprintf('The products property can only contain items of \StructType\ExternalProduct, "%s" given', is_object($collectionProductsItem) ? get_class($collectionProductsItem) : gettype($collectionProductsItem)), __LINE__);
            }
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalProduct $item
     * @return \StructType\Collection
     */
    public function addToProducts(\StructType\ExternalProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalProduct) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of \StructType\ExternalProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get skus value
     * @return string[]|null
     */
    public function getSkus()
    {
        return $this->skus;
    }
    /**
     * Set skus value
     * @throws \InvalidArgumentException
     * @param string[] $skus
     * @return \StructType\Collection
     */
    public function setSkus(array $skus = array())
    {
        foreach ($skus as $collectionSkusItem) {
            // validation for constraint: itemType
            if (!is_string($collectionSkusItem)) {
                throw new \InvalidArgumentException(sprintf('The skus property can only contain items of string, "%s" given', is_object($collectionSkusItem) ? get_class($collectionSkusItem) : gettype($collectionSkusItem)), __LINE__);
            }
        }
        $this->skus = $skus;
        return $this;
    }
    /**
     * Add item to skus value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Collection
     */
    public function addToSkus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The skus property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->skus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Collection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
