<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatus $parameters
     * @return \StructType\GetOrderStatusResponse|bool
     */
    public function getOrderStatus(\StructType\GetOrderStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderByCustomerName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderByCustomerName $parameters
     * @return \StructType\GetOrderByCustomerNameResponse|bool
     */
    public function getOrderByCustomerName(\StructType\GetOrderByCustomerName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderByCustomerName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderStatusHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatusHistory $parameters
     * @return \StructType\GetOrderStatusHistoryResponse|bool
     */
    public function getOrderStatusHistory(\StructType\GetOrderStatusHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderStatusHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetOrderByCustomerNameResponse|\StructType\GetOrderStatusHistoryResponse|\StructType\GetOrderStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
