<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

/**
 * This class stands for ValueType ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: ValueType - enum
 * - nillable: true
 * - type: tns:ValueType
 * @subpackage Enumerations
 */
class ValueType
{
    /**
     * Constant for value 'String'
     * Meta information extracted from the WSDL
     * - documentation: String
     * @return string 'String'
     */
    const VALUE_STRING = 'String';
    /**
     * Constant for value 'Decimal'
     * Meta information extracted from the WSDL
     * - documentation: Decimal
     * @return string 'Decimal'
     */
    const VALUE_DECIMAL = 'Decimal';
    /**
     * Constant for value 'DateTime'
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * @return string 'DateTime'
     */
    const VALUE_DATE_TIME = 'DateTime';
    /**
     * Constant for value 'Enumeration'
     * Meta information extracted from the WSDL
     * - documentation: Enumeration
     * @return string 'Enumeration'
     */
    const VALUE_ENUMERATION = 'Enumeration';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_DATE_TIME
     * @uses self::VALUE_ENUMERATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_DECIMAL,
            self::VALUE_DATE_TIME,
            self::VALUE_ENUMERATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
