<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceAvailabilityService
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\ServiceAvailabilityService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ValidateCityPostalCodeZip
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ServiceAvailabilityService\RequestContext
     * - SOAPHeaders: required
     * - documentation: ValidateCityPostalCodeZip @param request ValidateCityPostalCodeZipRequest @return ValidateCityPostalCodeZipResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ValidateCityPostalCodeZipRequestContainer $validateCityPostalCodeZipRequest
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ValidateCityPostalCodeZipResponseContainer|bool
     */
    public function ValidateCityPostalCodeZip(\Pepitelabs\PWS\ServiceAvailabilityService\ValidateCityPostalCodeZipRequestContainer $validateCityPostalCodeZipRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateCityPostalCodeZip($validateCityPostalCodeZipRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ValidateCityPostalCodeZipResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
