<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOptionRules ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: ServiceOptionRules
 * - nillable: true
 * - type: tns:ServiceOptionRules
 * @subpackage Structs
 */
class ServiceOptionRules extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: ServiceID - string
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The Exclusions
     * Meta information extracted from the WSDL
     * - documentation: Exclusions - OptionIDValuePair[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair
     */
    public $Exclusions;
    /**
     * The Inclusions
     * Meta information extracted from the WSDL
     * - documentation: Inclusions - OptionIDValuePair[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair
     */
    public $Inclusions;
    /**
     * Constructor method for ServiceOptionRules
     * @uses ServiceOptionRules::setServiceID()
     * @uses ServiceOptionRules::setExclusions()
     * @uses ServiceOptionRules::setInclusions()
     * @param string $serviceID
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $exclusions
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $inclusions
     */
    public function __construct($serviceID = null, \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $exclusions = null, \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $inclusions = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setExclusions($exclusions)
            ->setInclusions($inclusions);
    }
    /**
     * Get ServiceID value
     * @return string|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceOptionRules
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get Exclusions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair|null
     */
    public function getExclusions()
    {
        return isset($this->Exclusions) ? $this->Exclusions : null;
    }
    /**
     * Set Exclusions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $exclusions
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceOptionRules
     */
    public function setExclusions(\Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $exclusions = null)
    {
        if (is_null($exclusions) || (is_array($exclusions) && empty($exclusions))) {
            unset($this->Exclusions);
        } else {
            $this->Exclusions = $exclusions;
        }
        return $this;
    }
    /**
     * Get Inclusions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair|null
     */
    public function getInclusions()
    {
        return isset($this->Inclusions) ? $this->Inclusions : null;
    }
    /**
     * Set Inclusions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $inclusions
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceOptionRules
     */
    public function setInclusions(\Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionIDValuePair $inclusions = null)
    {
        if (is_null($inclusions) || (is_array($inclusions) && empty($inclusions))) {
            unset($this->Inclusions);
        } else {
            $this->Inclusions = $inclusions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceOptionRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
