<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Option ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: Option
 * - nillable: true
 * - type: tns:Option
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: ID - string
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - documentation: ValueType - ValueType
     * @var string
     */
    public $ValueType;
    /**
     * The AvailableForPieces
     * Meta information extracted from the WSDL
     * - documentation: AvailableForPieces - bool
     * @var bool
     */
    public $AvailableForPieces;
    /**
     * The PossibleValues
     * Meta information extracted from the WSDL
     * - documentation: PossibleValues - OptionValue[]
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue
     */
    public $PossibleValues;
    /**
     * The ChildServiceOptions
     * Meta information extracted from the WSDL
     * - documentation: ChildServiceOptions - Option[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption
     */
    public $ChildServiceOptions;
    /**
     * Constructor method for Option
     * @uses Option::setID()
     * @uses Option::setDescription()
     * @uses Option::setValueType()
     * @uses Option::setAvailableForPieces()
     * @uses Option::setPossibleValues()
     * @uses Option::setChildServiceOptions()
     * @param string $iD
     * @param string $description
     * @param string $valueType
     * @param bool $availableForPieces
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue $possibleValues
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption $childServiceOptions
     */
    public function __construct($iD = null, $description = null, $valueType = null, $availableForPieces = null, \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue $possibleValues = null, \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption $childServiceOptions = null)
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setValueType($valueType)
            ->setAvailableForPieces($availableForPieces)
            ->setPossibleValues($possibleValues)
            ->setChildServiceOptions($childServiceOptions);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @uses \Pepitelabs\PWS\ServiceAvailabilityService\ValueType::valueIsValid()
     * @uses \Pepitelabs\PWS\ServiceAvailabilityService\ValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ServiceAvailabilityService\ValueType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ServiceAvailabilityService\ValueType', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \Pepitelabs\PWS\ServiceAvailabilityService\ValueType::getValidValues())), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get AvailableForPieces value
     * @return bool|null
     */
    public function getAvailableForPieces()
    {
        return $this->AvailableForPieces;
    }
    /**
     * Set AvailableForPieces value
     * @param bool $availableForPieces
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setAvailableForPieces($availableForPieces = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForPieces) && !is_bool($availableForPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForPieces, true), gettype($availableForPieces)), __LINE__);
        }
        $this->AvailableForPieces = $availableForPieces;
        return $this;
    }
    /**
     * Get PossibleValues value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue|null
     */
    public function getPossibleValues()
    {
        return $this->PossibleValues;
    }
    /**
     * Set PossibleValues value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue $possibleValues
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setPossibleValues(\Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOptionValue $possibleValues = null)
    {
        $this->PossibleValues = $possibleValues;
        return $this;
    }
    /**
     * Get ChildServiceOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption|null
     */
    public function getChildServiceOptions()
    {
        return isset($this->ChildServiceOptions) ? $this->ChildServiceOptions : null;
    }
    /**
     * Set ChildServiceOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption $childServiceOptions
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public function setChildServiceOptions(\Pepitelabs\PWS\ServiceAvailabilityService\ArrayOfOption $childServiceOptions = null)
    {
        if (is_null($childServiceOptions) || (is_array($childServiceOptions) && empty($childServiceOptions))) {
            unset($this->ChildServiceOptions);
        } else {
            $this->ChildServiceOptions = $childServiceOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Option
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
