<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServicesOptionsRequestContainer
 * ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: GetServicesOptionsRequest
 * - nillable: true
 * - type: tns:GetServicesOptionsRequestContainer
 * @subpackage Structs
 */
class GetServicesOptionsRequestContainer extends RequestContainer
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The SenderAddress
     * Meta information extracted from the WSDL
     * - documentation: SenderAddress - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress
     */
    public $SenderAddress;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - documentation: ReceiverAddress - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress
     */
    public $ReceiverAddress;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - documentation: ShipmentDate - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentDate;
    /**
     * Constructor method for GetServicesOptionsRequestContainer
     * @uses GetServicesOptionsRequestContainer::setBillingAccountNumber()
     * @uses GetServicesOptionsRequestContainer::setSenderAddress()
     * @uses GetServicesOptionsRequestContainer::setReceiverAddress()
     * @uses GetServicesOptionsRequestContainer::setShipmentDate()
     * @param string $billingAccountNumber
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress
     * @param string $shipmentDate
     */
    public function __construct($billingAccountNumber = null, \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress = null, \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress = null, $shipmentDate = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setSenderAddress($senderAddress)
            ->setReceiverAddress($receiverAddress)
            ->setShipmentDate($shipmentDate);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get SenderAddress value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress|null
     */
    public function getSenderAddress()
    {
        return $this->SenderAddress;
    }
    /**
     * Set SenderAddress value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer
     */
    public function setSenderAddress(\Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress = null)
    {
        $this->SenderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer
     */
    public function setReceiverAddress(\Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress = null)
    {
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDate
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
