<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceAvailabilityService
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\ServiceAvailabilityService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetServicesOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ServiceAvailabilityService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetServicesOptions @param request GetServicesOptionsRequest @return GetServicesOptionsResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer $getServicesOptionsRequest
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsResponseContainer|bool
     */
    public function GetServicesOptions(\Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsRequestContainer $getServicesOptionsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServicesOptions($getServicesOptionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceRules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ServiceAvailabilityService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetServiceRules @param request GetServiceRulesRequest @return GetServiceRulesResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer $getServiceRulesRequest
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesResponseContainer|bool
     */
    public function GetServiceRules(\Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer $getServiceRulesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServiceRules($getServiceRulesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesResponseContainer|\Pepitelabs\PWS\ServiceAvailabilityService\GetServicesOptionsResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
