<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRule ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: ServiceRules
 * - nillable: true
 * - type: tns:ServiceRule
 * @subpackage Structs
 */
class ServiceRule extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: ServiceID - string
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The MinimumTotalPieces
     * Meta information extracted from the WSDL
     * - documentation: MinimumTotalPieces - int
     * @var int
     */
    public $MinimumTotalPieces;
    /**
     * The MaximumTotalPieces
     * Meta information extracted from the WSDL
     * - documentation: MaximumTotalPieces - int
     * @var int
     */
    public $MaximumTotalPieces;
    /**
     * The MinimumTotalWeight
     * Meta information extracted from the WSDL
     * - documentation: MinimumTotalWeight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $MinimumTotalWeight;
    /**
     * The MaximumTotalWeight
     * Meta information extracted from the WSDL
     * - documentation: MaximumTotalWeight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $MaximumTotalWeight;
    /**
     * The MinimumPieceWeight
     * Meta information extracted from the WSDL
     * - documentation: MinimumPieceWeight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $MinimumPieceWeight;
    /**
     * The MaximumPieceWeight
     * Meta information extracted from the WSDL
     * - documentation: MaximumPieceWeight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $MaximumPieceWeight;
    /**
     * The MinimumPieceLength
     * Meta information extracted from the WSDL
     * - documentation: MinimumPieceLength - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MinimumPieceLength;
    /**
     * The MaximumPieceLength
     * Meta information extracted from the WSDL
     * - documentation: MaximumPieceLength - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MaximumPieceLength;
    /**
     * The MinimumPieceWidth
     * Meta information extracted from the WSDL
     * - documentation: MinimumPieceWidth - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MinimumPieceWidth;
    /**
     * The MaximumPieceWidth
     * Meta information extracted from the WSDL
     * - documentation: MaximumPieceWidth - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MaximumPieceWidth;
    /**
     * The MinimumPieceHeight
     * Meta information extracted from the WSDL
     * - documentation: MinimumPieceHeight - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MinimumPieceHeight;
    /**
     * The MaximumPieceHeight
     * Meta information extracted from the WSDL
     * - documentation: MaximumPieceHeight - Dimension
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MaximumPieceHeight;
    /**
     * The MaximumSize
     * Meta information extracted from the WSDL
     * - documentation: MaximumSize - Size
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MaximumSize;
    /**
     * The MaximumDeclaredValue
     * Meta information extracted from the WSDL
     * - documentation: MaximumDeclaredValue - decimal
     * - minOccurs: 0
     * @var float
     */
    public $MaximumDeclaredValue;
    /**
     * The AndMinimumLengthFlatPackage
     * Meta information extracted from the WSDL
     * - documentation: Minimum Length for Special Handling Type: Flat Package
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $AndMinimumLengthFlatPackage;
    /**
     * The AndMaximumLengthFlatPackage
     * Meta information extracted from the WSDL
     * - documentation: Maximum Length for Special Handling Type: Flat Package
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $AndMaximumLengthFlatPackage;
    /**
     * The AndMaximumHeightFlatPackage
     * Meta information extracted from the WSDL
     * - documentation: Maximum Height for Special Handling Type: Flat Package
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $AndMaximumHeightFlatPackage;
    /**
     * The AndMinimumSizeLargePackage
     * Meta information extracted from the WSDL
     * - documentation: Maximum Weight for Special Handling Type: Flat Package
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $AndMinimumSizeLargePackage;
    /**
     * The MinimumSizeLargePackage
     * Meta information extracted from the WSDL
     * - documentation: Maximum Size for Special Handling Type: Large Package
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $MinimumSizeLargePackage;
    /**
     * The OrMinimumWeightOverSized
     * Meta information extracted from the WSDL
     * - documentation: Minumum Weight for Special Handling Type: OverSized
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $OrMinimumWeightOverSized;
    /**
     * The OrMinimumLengthOverSized
     * Meta information extracted from the WSDL
     * - documentation: Minumum Length for Special Handling Type: OverSized
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Dimension
     */
    public $OrMinimumLengthOverSized;
    /**
     * The AndMinimumWeightResidentialAreaHeavyWeight
     * Meta information extracted from the WSDL
     * - documentation: Minumum Weight for Special Handling Type: Residential Area Heavy Weight
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\Weight
     */
    public $AndMinimumWeightResidentialAreaHeavyWeight;
    /**
     * The AndLowerDensityDeliveryResidentialAreaHeavyWeight
     * Meta information extracted from the WSDL
     * - documentation: LDD for Special Handling Type: Residential Area Heavy Weight
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AndLowerDensityDeliveryResidentialAreaHeavyWeight;
    /**
     * The AndHoldForPickupResidentialAreaHeavyWeight
     * Meta information extracted from the WSDL
     * - documentation: HFPU for Special Handling Type: Residential Area Heavy Weight
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AndHoldForPickupResidentialAreaHeavyWeight;
    /**
     * Constructor method for ServiceRule
     * @uses ServiceRule::setServiceID()
     * @uses ServiceRule::setMinimumTotalPieces()
     * @uses ServiceRule::setMaximumTotalPieces()
     * @uses ServiceRule::setMinimumTotalWeight()
     * @uses ServiceRule::setMaximumTotalWeight()
     * @uses ServiceRule::setMinimumPieceWeight()
     * @uses ServiceRule::setMaximumPieceWeight()
     * @uses ServiceRule::setMinimumPieceLength()
     * @uses ServiceRule::setMaximumPieceLength()
     * @uses ServiceRule::setMinimumPieceWidth()
     * @uses ServiceRule::setMaximumPieceWidth()
     * @uses ServiceRule::setMinimumPieceHeight()
     * @uses ServiceRule::setMaximumPieceHeight()
     * @uses ServiceRule::setMaximumSize()
     * @uses ServiceRule::setMaximumDeclaredValue()
     * @uses ServiceRule::setAndMinimumLengthFlatPackage()
     * @uses ServiceRule::setAndMaximumLengthFlatPackage()
     * @uses ServiceRule::setAndMaximumHeightFlatPackage()
     * @uses ServiceRule::setAndMinimumSizeLargePackage()
     * @uses ServiceRule::setMinimumSizeLargePackage()
     * @uses ServiceRule::setOrMinimumWeightOverSized()
     * @uses ServiceRule::setOrMinimumLengthOverSized()
     * @uses ServiceRule::setAndMinimumWeightResidentialAreaHeavyWeight()
     * @uses ServiceRule::setAndLowerDensityDeliveryResidentialAreaHeavyWeight()
     * @uses ServiceRule::setAndHoldForPickupResidentialAreaHeavyWeight()
     * @param string $serviceID
     * @param int $minimumTotalPieces
     * @param int $maximumTotalPieces
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumTotalWeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumTotalWeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumPieceWeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumPieceWeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceLength
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceLength
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceWidth
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceWidth
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceHeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceHeight
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumSize
     * @param float $maximumDeclaredValue
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumLengthFlatPackage
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumLengthFlatPackage
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumHeightFlatPackage
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumSizeLargePackage
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumSizeLargePackage
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $orMinimumWeightOverSized
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $orMinimumLengthOverSized
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $andMinimumWeightResidentialAreaHeavyWeight
     * @param string $andLowerDensityDeliveryResidentialAreaHeavyWeight
     * @param string $andHoldForPickupResidentialAreaHeavyWeight
     */
    public function __construct($serviceID = null, $minimumTotalPieces = null, $maximumTotalPieces = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumTotalWeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumTotalWeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumPieceWeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumPieceWeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceLength = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceLength = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceWidth = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceWidth = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceHeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceHeight = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumSize = null, $maximumDeclaredValue = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumLengthFlatPackage = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumLengthFlatPackage = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumHeightFlatPackage = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumSizeLargePackage = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumSizeLargePackage = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $orMinimumWeightOverSized = null, \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $orMinimumLengthOverSized = null, \Pepitelabs\PWS\ServiceAvailabilityService\Weight $andMinimumWeightResidentialAreaHeavyWeight = null, $andLowerDensityDeliveryResidentialAreaHeavyWeight = null, $andHoldForPickupResidentialAreaHeavyWeight = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setMinimumTotalPieces($minimumTotalPieces)
            ->setMaximumTotalPieces($maximumTotalPieces)
            ->setMinimumTotalWeight($minimumTotalWeight)
            ->setMaximumTotalWeight($maximumTotalWeight)
            ->setMinimumPieceWeight($minimumPieceWeight)
            ->setMaximumPieceWeight($maximumPieceWeight)
            ->setMinimumPieceLength($minimumPieceLength)
            ->setMaximumPieceLength($maximumPieceLength)
            ->setMinimumPieceWidth($minimumPieceWidth)
            ->setMaximumPieceWidth($maximumPieceWidth)
            ->setMinimumPieceHeight($minimumPieceHeight)
            ->setMaximumPieceHeight($maximumPieceHeight)
            ->setMaximumSize($maximumSize)
            ->setMaximumDeclaredValue($maximumDeclaredValue)
            ->setAndMinimumLengthFlatPackage($andMinimumLengthFlatPackage)
            ->setAndMaximumLengthFlatPackage($andMaximumLengthFlatPackage)
            ->setAndMaximumHeightFlatPackage($andMaximumHeightFlatPackage)
            ->setAndMinimumSizeLargePackage($andMinimumSizeLargePackage)
            ->setMinimumSizeLargePackage($minimumSizeLargePackage)
            ->setOrMinimumWeightOverSized($orMinimumWeightOverSized)
            ->setOrMinimumLengthOverSized($orMinimumLengthOverSized)
            ->setAndMinimumWeightResidentialAreaHeavyWeight($andMinimumWeightResidentialAreaHeavyWeight)
            ->setAndLowerDensityDeliveryResidentialAreaHeavyWeight($andLowerDensityDeliveryResidentialAreaHeavyWeight)
            ->setAndHoldForPickupResidentialAreaHeavyWeight($andHoldForPickupResidentialAreaHeavyWeight);
    }
    /**
     * Get ServiceID value
     * @return string|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get MinimumTotalPieces value
     * @return int|null
     */
    public function getMinimumTotalPieces()
    {
        return $this->MinimumTotalPieces;
    }
    /**
     * Set MinimumTotalPieces value
     * @param int $minimumTotalPieces
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumTotalPieces($minimumTotalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($minimumTotalPieces) && !(is_int($minimumTotalPieces) || ctype_digit($minimumTotalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumTotalPieces, true), gettype($minimumTotalPieces)), __LINE__);
        }
        $this->MinimumTotalPieces = $minimumTotalPieces;
        return $this;
    }
    /**
     * Get MaximumTotalPieces value
     * @return int|null
     */
    public function getMaximumTotalPieces()
    {
        return $this->MaximumTotalPieces;
    }
    /**
     * Set MaximumTotalPieces value
     * @param int $maximumTotalPieces
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumTotalPieces($maximumTotalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($maximumTotalPieces) && !(is_int($maximumTotalPieces) || ctype_digit($maximumTotalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumTotalPieces, true), gettype($maximumTotalPieces)), __LINE__);
        }
        $this->MaximumTotalPieces = $maximumTotalPieces;
        return $this;
    }
    /**
     * Get MinimumTotalWeight value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getMinimumTotalWeight()
    {
        return $this->MinimumTotalWeight;
    }
    /**
     * Set MinimumTotalWeight value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumTotalWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumTotalWeight(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumTotalWeight = null)
    {
        $this->MinimumTotalWeight = $minimumTotalWeight;
        return $this;
    }
    /**
     * Get MaximumTotalWeight value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getMaximumTotalWeight()
    {
        return $this->MaximumTotalWeight;
    }
    /**
     * Set MaximumTotalWeight value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumTotalWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumTotalWeight(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumTotalWeight = null)
    {
        $this->MaximumTotalWeight = $maximumTotalWeight;
        return $this;
    }
    /**
     * Get MinimumPieceWeight value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getMinimumPieceWeight()
    {
        return $this->MinimumPieceWeight;
    }
    /**
     * Set MinimumPieceWeight value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumPieceWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumPieceWeight(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $minimumPieceWeight = null)
    {
        $this->MinimumPieceWeight = $minimumPieceWeight;
        return $this;
    }
    /**
     * Get MaximumPieceWeight value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getMaximumPieceWeight()
    {
        return $this->MaximumPieceWeight;
    }
    /**
     * Set MaximumPieceWeight value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumPieceWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumPieceWeight(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $maximumPieceWeight = null)
    {
        $this->MaximumPieceWeight = $maximumPieceWeight;
        return $this;
    }
    /**
     * Get MinimumPieceLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMinimumPieceLength()
    {
        return isset($this->MinimumPieceLength) ? $this->MinimumPieceLength : null;
    }
    /**
     * Set MinimumPieceLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceLength
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumPieceLength(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceLength = null)
    {
        if (is_null($minimumPieceLength) || (is_array($minimumPieceLength) && empty($minimumPieceLength))) {
            unset($this->MinimumPieceLength);
        } else {
            $this->MinimumPieceLength = $minimumPieceLength;
        }
        return $this;
    }
    /**
     * Get MaximumPieceLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMaximumPieceLength()
    {
        return isset($this->MaximumPieceLength) ? $this->MaximumPieceLength : null;
    }
    /**
     * Set MaximumPieceLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceLength
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumPieceLength(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceLength = null)
    {
        if (is_null($maximumPieceLength) || (is_array($maximumPieceLength) && empty($maximumPieceLength))) {
            unset($this->MaximumPieceLength);
        } else {
            $this->MaximumPieceLength = $maximumPieceLength;
        }
        return $this;
    }
    /**
     * Get MinimumPieceWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMinimumPieceWidth()
    {
        return isset($this->MinimumPieceWidth) ? $this->MinimumPieceWidth : null;
    }
    /**
     * Set MinimumPieceWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceWidth
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumPieceWidth(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceWidth = null)
    {
        if (is_null($minimumPieceWidth) || (is_array($minimumPieceWidth) && empty($minimumPieceWidth))) {
            unset($this->MinimumPieceWidth);
        } else {
            $this->MinimumPieceWidth = $minimumPieceWidth;
        }
        return $this;
    }
    /**
     * Get MaximumPieceWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMaximumPieceWidth()
    {
        return isset($this->MaximumPieceWidth) ? $this->MaximumPieceWidth : null;
    }
    /**
     * Set MaximumPieceWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceWidth
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumPieceWidth(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceWidth = null)
    {
        if (is_null($maximumPieceWidth) || (is_array($maximumPieceWidth) && empty($maximumPieceWidth))) {
            unset($this->MaximumPieceWidth);
        } else {
            $this->MaximumPieceWidth = $maximumPieceWidth;
        }
        return $this;
    }
    /**
     * Get MinimumPieceHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMinimumPieceHeight()
    {
        return isset($this->MinimumPieceHeight) ? $this->MinimumPieceHeight : null;
    }
    /**
     * Set MinimumPieceHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceHeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumPieceHeight(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumPieceHeight = null)
    {
        if (is_null($minimumPieceHeight) || (is_array($minimumPieceHeight) && empty($minimumPieceHeight))) {
            unset($this->MinimumPieceHeight);
        } else {
            $this->MinimumPieceHeight = $minimumPieceHeight;
        }
        return $this;
    }
    /**
     * Get MaximumPieceHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMaximumPieceHeight()
    {
        return isset($this->MaximumPieceHeight) ? $this->MaximumPieceHeight : null;
    }
    /**
     * Set MaximumPieceHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceHeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumPieceHeight(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumPieceHeight = null)
    {
        if (is_null($maximumPieceHeight) || (is_array($maximumPieceHeight) && empty($maximumPieceHeight))) {
            unset($this->MaximumPieceHeight);
        } else {
            $this->MaximumPieceHeight = $maximumPieceHeight;
        }
        return $this;
    }
    /**
     * Get MaximumSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMaximumSize()
    {
        return isset($this->MaximumSize) ? $this->MaximumSize : null;
    }
    /**
     * Set MaximumSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumSize
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumSize(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $maximumSize = null)
    {
        if (is_null($maximumSize) || (is_array($maximumSize) && empty($maximumSize))) {
            unset($this->MaximumSize);
        } else {
            $this->MaximumSize = $maximumSize;
        }
        return $this;
    }
    /**
     * Get MaximumDeclaredValue value
     * @return float|null
     */
    public function getMaximumDeclaredValue()
    {
        return $this->MaximumDeclaredValue;
    }
    /**
     * Set MaximumDeclaredValue value
     * @param float $maximumDeclaredValue
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMaximumDeclaredValue($maximumDeclaredValue = null)
    {
        // validation for constraint: float
        if (!is_null($maximumDeclaredValue) && !(is_float($maximumDeclaredValue) || is_numeric($maximumDeclaredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumDeclaredValue, true), gettype($maximumDeclaredValue)), __LINE__);
        }
        $this->MaximumDeclaredValue = $maximumDeclaredValue;
        return $this;
    }
    /**
     * Get AndMinimumLengthFlatPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getAndMinimumLengthFlatPackage()
    {
        return isset($this->AndMinimumLengthFlatPackage) ? $this->AndMinimumLengthFlatPackage : null;
    }
    /**
     * Set AndMinimumLengthFlatPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumLengthFlatPackage
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndMinimumLengthFlatPackage(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumLengthFlatPackage = null)
    {
        if (is_null($andMinimumLengthFlatPackage) || (is_array($andMinimumLengthFlatPackage) && empty($andMinimumLengthFlatPackage))) {
            unset($this->AndMinimumLengthFlatPackage);
        } else {
            $this->AndMinimumLengthFlatPackage = $andMinimumLengthFlatPackage;
        }
        return $this;
    }
    /**
     * Get AndMaximumLengthFlatPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getAndMaximumLengthFlatPackage()
    {
        return isset($this->AndMaximumLengthFlatPackage) ? $this->AndMaximumLengthFlatPackage : null;
    }
    /**
     * Set AndMaximumLengthFlatPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumLengthFlatPackage
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndMaximumLengthFlatPackage(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumLengthFlatPackage = null)
    {
        if (is_null($andMaximumLengthFlatPackage) || (is_array($andMaximumLengthFlatPackage) && empty($andMaximumLengthFlatPackage))) {
            unset($this->AndMaximumLengthFlatPackage);
        } else {
            $this->AndMaximumLengthFlatPackage = $andMaximumLengthFlatPackage;
        }
        return $this;
    }
    /**
     * Get AndMaximumHeightFlatPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getAndMaximumHeightFlatPackage()
    {
        return isset($this->AndMaximumHeightFlatPackage) ? $this->AndMaximumHeightFlatPackage : null;
    }
    /**
     * Set AndMaximumHeightFlatPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumHeightFlatPackage
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndMaximumHeightFlatPackage(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMaximumHeightFlatPackage = null)
    {
        if (is_null($andMaximumHeightFlatPackage) || (is_array($andMaximumHeightFlatPackage) && empty($andMaximumHeightFlatPackage))) {
            unset($this->AndMaximumHeightFlatPackage);
        } else {
            $this->AndMaximumHeightFlatPackage = $andMaximumHeightFlatPackage;
        }
        return $this;
    }
    /**
     * Get AndMinimumSizeLargePackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getAndMinimumSizeLargePackage()
    {
        return isset($this->AndMinimumSizeLargePackage) ? $this->AndMinimumSizeLargePackage : null;
    }
    /**
     * Set AndMinimumSizeLargePackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumSizeLargePackage
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndMinimumSizeLargePackage(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $andMinimumSizeLargePackage = null)
    {
        if (is_null($andMinimumSizeLargePackage) || (is_array($andMinimumSizeLargePackage) && empty($andMinimumSizeLargePackage))) {
            unset($this->AndMinimumSizeLargePackage);
        } else {
            $this->AndMinimumSizeLargePackage = $andMinimumSizeLargePackage;
        }
        return $this;
    }
    /**
     * Get MinimumSizeLargePackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getMinimumSizeLargePackage()
    {
        return isset($this->MinimumSizeLargePackage) ? $this->MinimumSizeLargePackage : null;
    }
    /**
     * Set MinimumSizeLargePackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumSizeLargePackage
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setMinimumSizeLargePackage(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $minimumSizeLargePackage = null)
    {
        if (is_null($minimumSizeLargePackage) || (is_array($minimumSizeLargePackage) && empty($minimumSizeLargePackage))) {
            unset($this->MinimumSizeLargePackage);
        } else {
            $this->MinimumSizeLargePackage = $minimumSizeLargePackage;
        }
        return $this;
    }
    /**
     * Get OrMinimumWeightOverSized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getOrMinimumWeightOverSized()
    {
        return isset($this->OrMinimumWeightOverSized) ? $this->OrMinimumWeightOverSized : null;
    }
    /**
     * Set OrMinimumWeightOverSized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $orMinimumWeightOverSized
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setOrMinimumWeightOverSized(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $orMinimumWeightOverSized = null)
    {
        if (is_null($orMinimumWeightOverSized) || (is_array($orMinimumWeightOverSized) && empty($orMinimumWeightOverSized))) {
            unset($this->OrMinimumWeightOverSized);
        } else {
            $this->OrMinimumWeightOverSized = $orMinimumWeightOverSized;
        }
        return $this;
    }
    /**
     * Get OrMinimumLengthOverSized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Dimension|null
     */
    public function getOrMinimumLengthOverSized()
    {
        return isset($this->OrMinimumLengthOverSized) ? $this->OrMinimumLengthOverSized : null;
    }
    /**
     * Set OrMinimumLengthOverSized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Dimension $orMinimumLengthOverSized
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setOrMinimumLengthOverSized(\Pepitelabs\PWS\ServiceAvailabilityService\Dimension $orMinimumLengthOverSized = null)
    {
        if (is_null($orMinimumLengthOverSized) || (is_array($orMinimumLengthOverSized) && empty($orMinimumLengthOverSized))) {
            unset($this->OrMinimumLengthOverSized);
        } else {
            $this->OrMinimumLengthOverSized = $orMinimumLengthOverSized;
        }
        return $this;
    }
    /**
     * Get AndMinimumWeightResidentialAreaHeavyWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\Weight|null
     */
    public function getAndMinimumWeightResidentialAreaHeavyWeight()
    {
        return isset($this->AndMinimumWeightResidentialAreaHeavyWeight) ? $this->AndMinimumWeightResidentialAreaHeavyWeight : null;
    }
    /**
     * Set AndMinimumWeightResidentialAreaHeavyWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\Weight $andMinimumWeightResidentialAreaHeavyWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndMinimumWeightResidentialAreaHeavyWeight(\Pepitelabs\PWS\ServiceAvailabilityService\Weight $andMinimumWeightResidentialAreaHeavyWeight = null)
    {
        if (is_null($andMinimumWeightResidentialAreaHeavyWeight) || (is_array($andMinimumWeightResidentialAreaHeavyWeight) && empty($andMinimumWeightResidentialAreaHeavyWeight))) {
            unset($this->AndMinimumWeightResidentialAreaHeavyWeight);
        } else {
            $this->AndMinimumWeightResidentialAreaHeavyWeight = $andMinimumWeightResidentialAreaHeavyWeight;
        }
        return $this;
    }
    /**
     * Get AndLowerDensityDeliveryResidentialAreaHeavyWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAndLowerDensityDeliveryResidentialAreaHeavyWeight()
    {
        return isset($this->AndLowerDensityDeliveryResidentialAreaHeavyWeight) ? $this->AndLowerDensityDeliveryResidentialAreaHeavyWeight : null;
    }
    /**
     * Set AndLowerDensityDeliveryResidentialAreaHeavyWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $andLowerDensityDeliveryResidentialAreaHeavyWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndLowerDensityDeliveryResidentialAreaHeavyWeight($andLowerDensityDeliveryResidentialAreaHeavyWeight = null)
    {
        // validation for constraint: string
        if (!is_null($andLowerDensityDeliveryResidentialAreaHeavyWeight) && !is_string($andLowerDensityDeliveryResidentialAreaHeavyWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($andLowerDensityDeliveryResidentialAreaHeavyWeight, true), gettype($andLowerDensityDeliveryResidentialAreaHeavyWeight)), __LINE__);
        }
        if (is_null($andLowerDensityDeliveryResidentialAreaHeavyWeight) || (is_array($andLowerDensityDeliveryResidentialAreaHeavyWeight) && empty($andLowerDensityDeliveryResidentialAreaHeavyWeight))) {
            unset($this->AndLowerDensityDeliveryResidentialAreaHeavyWeight);
        } else {
            $this->AndLowerDensityDeliveryResidentialAreaHeavyWeight = $andLowerDensityDeliveryResidentialAreaHeavyWeight;
        }
        return $this;
    }
    /**
     * Get AndHoldForPickupResidentialAreaHeavyWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAndHoldForPickupResidentialAreaHeavyWeight()
    {
        return isset($this->AndHoldForPickupResidentialAreaHeavyWeight) ? $this->AndHoldForPickupResidentialAreaHeavyWeight : null;
    }
    /**
     * Set AndHoldForPickupResidentialAreaHeavyWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $andHoldForPickupResidentialAreaHeavyWeight
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public function setAndHoldForPickupResidentialAreaHeavyWeight($andHoldForPickupResidentialAreaHeavyWeight = null)
    {
        // validation for constraint: string
        if (!is_null($andHoldForPickupResidentialAreaHeavyWeight) && !is_string($andHoldForPickupResidentialAreaHeavyWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($andHoldForPickupResidentialAreaHeavyWeight, true), gettype($andHoldForPickupResidentialAreaHeavyWeight)), __LINE__);
        }
        if (is_null($andHoldForPickupResidentialAreaHeavyWeight) || (is_array($andHoldForPickupResidentialAreaHeavyWeight) && empty($andHoldForPickupResidentialAreaHeavyWeight))) {
            unset($this->AndHoldForPickupResidentialAreaHeavyWeight);
        } else {
            $this->AndHoldForPickupResidentialAreaHeavyWeight = $andHoldForPickupResidentialAreaHeavyWeight;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ServiceRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
