<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionValue ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: OptionValue
 * - nillable: true
 * - type: tns:OptionValue
 * @subpackage Structs
 */
class OptionValue extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Value - string
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for OptionValue
     * @uses OptionValue::setValue()
     * @uses OptionValue::setDescription()
     * @param string $value
     * @param string $description
     */
    public function __construct($value = null, $description = null)
    {
        $this
            ->setValue($value)
            ->setDescription($description);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\OptionValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\OptionValue
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\OptionValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
