<?php

namespace Pepitelabs\PWS\ServiceAvailabilityService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceRulesRequestContainer ServiceAvailabilityService
 * Meta information extracted from the WSDL
 * - documentation: GetServiceRulesRequest
 * - nillable: true
 * - type: tns:GetServiceRulesRequestContainer
 * @subpackage Structs
 */
class GetServiceRulesRequestContainer extends RequestContainer
{
    /**
     * The BillingAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: BillingAccountNumber - string
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The SenderAddress
     * Meta information extracted from the WSDL
     * - documentation: SenderAddress - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress
     */
    public $SenderAddress;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - documentation: ReceiverAddress - Address
     * - nillable: true
     * @var \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress
     */
    public $ReceiverAddress;
    /**
     * Constructor method for GetServiceRulesRequestContainer
     * @uses GetServiceRulesRequestContainer::setBillingAccountNumber()
     * @uses GetServiceRulesRequestContainer::setSenderAddress()
     * @uses GetServiceRulesRequestContainer::setReceiverAddress()
     * @param string $billingAccountNumber
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress
     */
    public function __construct($billingAccountNumber = null, \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress = null, \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress = null)
    {
        $this
            ->setBillingAccountNumber($billingAccountNumber)
            ->setSenderAddress($senderAddress)
            ->setReceiverAddress($receiverAddress);
    }
    /**
     * Get BillingAccountNumber value
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return $this->BillingAccountNumber;
    }
    /**
     * Set BillingAccountNumber value
     * @param string $billingAccountNumber
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAccountNumber, true), gettype($billingAccountNumber)), __LINE__);
        }
        $this->BillingAccountNumber = $billingAccountNumber;
        return $this;
    }
    /**
     * Get SenderAddress value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress|null
     */
    public function getSenderAddress()
    {
        return $this->SenderAddress;
    }
    /**
     * Set SenderAddress value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer
     */
    public function setSenderAddress(\Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $senderAddress = null)
    {
        $this->SenderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param \Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer
     */
    public function setReceiverAddress(\Pepitelabs\PWS\ServiceAvailabilityService\ShortAddress $receiverAddress = null)
    {
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ServiceAvailabilityService\GetServiceRulesRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
