<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseBean StructType
 * Meta information extracted from the WSDL
 * - type: tns:responseBean
 * @subpackage Structs
 */
class ResponseBean extends AbstractStructBase
{
    /**
     * The interfaceId
     * @var string
     */
    public $interfaceId;
    /**
     * The providerId
     * @var string
     */
    public $providerId;
    /**
     * The providerRequestId
     * @var string
     */
    public $providerRequestId;
    /**
     * The providerMessageSendTime
     * @var string
     */
    public $providerMessageSendTime;
    /**
     * The responseAck
     * @var int
     */
    public $responseAck;
    /**
     * The responseData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $responseData;
    /**
     * The techMessageCode
     * @var string
     */
    public $techMessageCode;
    /**
     * The techMessageDesc
     * @var string
     */
    public $techMessageDesc;
    /**
     * Constructor method for responseBean
     * @uses ResponseBean::setInterfaceId()
     * @uses ResponseBean::setProviderId()
     * @uses ResponseBean::setProviderRequestId()
     * @uses ResponseBean::setProviderMessageSendTime()
     * @uses ResponseBean::setResponseAck()
     * @uses ResponseBean::setResponseData()
     * @uses ResponseBean::setTechMessageCode()
     * @uses ResponseBean::setTechMessageDesc()
     * @param string $interfaceId
     * @param string $providerId
     * @param string $providerRequestId
     * @param string $providerMessageSendTime
     * @param int $responseAck
     * @param string $responseData
     * @param string $techMessageCode
     * @param string $techMessageDesc
     */
    public function __construct($interfaceId = null, $providerId = null, $providerRequestId = null, $providerMessageSendTime = null, $responseAck = null, $responseData = null, $techMessageCode = null, $techMessageDesc = null)
    {
        $this
            ->setInterfaceId($interfaceId)
            ->setProviderId($providerId)
            ->setProviderRequestId($providerRequestId)
            ->setProviderMessageSendTime($providerMessageSendTime)
            ->setResponseAck($responseAck)
            ->setResponseData($responseData)
            ->setTechMessageCode($techMessageCode)
            ->setTechMessageDesc($techMessageDesc);
    }
    /**
     * Get interfaceId value
     * @return string|null
     */
    public function getInterfaceId()
    {
        return $this->interfaceId;
    }
    /**
     * Set interfaceId value
     * @param string $interfaceId
     * @return \StructType\ResponseBean
     */
    public function setInterfaceId($interfaceId = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceId) && !is_string($interfaceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfaceId, true), gettype($interfaceId)), __LINE__);
        }
        $this->interfaceId = $interfaceId;
        return $this;
    }
    /**
     * Get providerId value
     * @return string|null
     */
    public function getProviderId()
    {
        return $this->providerId;
    }
    /**
     * Set providerId value
     * @param string $providerId
     * @return \StructType\ResponseBean
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerId, true), gettype($providerId)), __LINE__);
        }
        $this->providerId = $providerId;
        return $this;
    }
    /**
     * Get providerRequestId value
     * @return string|null
     */
    public function getProviderRequestId()
    {
        return $this->providerRequestId;
    }
    /**
     * Set providerRequestId value
     * @param string $providerRequestId
     * @return \StructType\ResponseBean
     */
    public function setProviderRequestId($providerRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($providerRequestId) && !is_string($providerRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerRequestId, true), gettype($providerRequestId)), __LINE__);
        }
        $this->providerRequestId = $providerRequestId;
        return $this;
    }
    /**
     * Get providerMessageSendTime value
     * @return string|null
     */
    public function getProviderMessageSendTime()
    {
        return $this->providerMessageSendTime;
    }
    /**
     * Set providerMessageSendTime value
     * @param string $providerMessageSendTime
     * @return \StructType\ResponseBean
     */
    public function setProviderMessageSendTime($providerMessageSendTime = null)
    {
        // validation for constraint: string
        if (!is_null($providerMessageSendTime) && !is_string($providerMessageSendTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerMessageSendTime, true), gettype($providerMessageSendTime)), __LINE__);
        }
        $this->providerMessageSendTime = $providerMessageSendTime;
        return $this;
    }
    /**
     * Get responseAck value
     * @return int|null
     */
    public function getResponseAck()
    {
        return $this->responseAck;
    }
    /**
     * Set responseAck value
     * @param int $responseAck
     * @return \StructType\ResponseBean
     */
    public function setResponseAck($responseAck = null)
    {
        // validation for constraint: int
        if (!is_null($responseAck) && !(is_int($responseAck) || ctype_digit($responseAck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseAck, true), gettype($responseAck)), __LINE__);
        }
        $this->responseAck = $responseAck;
        return $this;
    }
    /**
     * Get responseData value
     * @return string|null
     */
    public function getResponseData()
    {
        return $this->responseData;
    }
    /**
     * Set responseData value
     * @param string $responseData
     * @return \StructType\ResponseBean
     */
    public function setResponseData($responseData = null)
    {
        // validation for constraint: string
        if (!is_null($responseData) && !is_string($responseData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseData, true), gettype($responseData)), __LINE__);
        }
        $this->responseData = $responseData;
        return $this;
    }
    /**
     * Get techMessageCode value
     * @return string|null
     */
    public function getTechMessageCode()
    {
        return $this->techMessageCode;
    }
    /**
     * Set techMessageCode value
     * @param string $techMessageCode
     * @return \StructType\ResponseBean
     */
    public function setTechMessageCode($techMessageCode = null)
    {
        // validation for constraint: string
        if (!is_null($techMessageCode) && !is_string($techMessageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($techMessageCode, true), gettype($techMessageCode)), __LINE__);
        }
        $this->techMessageCode = $techMessageCode;
        return $this;
    }
    /**
     * Get techMessageDesc value
     * @return string|null
     */
    public function getTechMessageDesc()
    {
        return $this->techMessageDesc;
    }
    /**
     * Set techMessageDesc value
     * @param string $techMessageDesc
     * @return \StructType\ResponseBean
     */
    public function setTechMessageDesc($techMessageDesc = null)
    {
        // validation for constraint: string
        if (!is_null($techMessageDesc) && !is_string($techMessageDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($techMessageDesc, true), gettype($techMessageDesc)), __LINE__);
        }
        $this->techMessageDesc = $techMessageDesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseBean
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
