<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login($userId, $password, $idleTime) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\Context()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsLoggedIn operation/method
 */
if ($is->IsLoggedIn(new \StructType\Context()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetMoreCommentText operation/method
 */
if ($get->GetMoreCommentText(new \StructType\Context(), new \StructType\Comment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReasonCodes operation/method
 */
if ($get->GetReasonCodes(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOOperation operation/method
 */
if ($get->GetMOOperation(new \StructType\Context(), new \StructType\MOOperationKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetViewDfns operation/method
 */
if ($get->GetViewDfns(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSortDfns operation/method
 */
if ($get->GetSortDfns(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubsetDfns operation/method
 */
if ($get->GetSubsetDfns(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTemplateDfns operation/method
 */
if ($get->GetTemplateDfns(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDomainClassInfo operation/method
 */
if ($get->GetDomainClassInfo(new \StructType\Context()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOOperationList operation/method
 */
if ($get->GetMOOperationList(new \StructType\Context(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOOperationListNext operation/method
 */
if ($get->GetMOOperationListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZ106338AT941112215352AAAAAAAAADSList operation/method
 */
if ($get->GetZ106338AT941112215352AAAAAAAAADSList(new \StructType\Context(), new \StructType\MOOperationKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZ106338AT941112215352AAAAAAAAADSListNext operation/method
 */
if ($get->GetZ106338AT941112215352AAAAAAAAADSListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedManufacturingOrder operation/method
 */
if ($get->GetRelatedManufacturingOrder(new \StructType\Context(), new \StructType\MOOperationKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedManufacturingOrderSplitsList operation/method
 */
if ($get->GetRelatedManufacturingOrderSplitsList(new \StructType\Context(), new \StructType\MOOperationKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedManufacturingOrderSplitsListNext operation/method
 */
if ($get->GetRelatedManufacturingOrderSplitsListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoMaterialsList operation/method
 */
if ($get->GetRelatedMoMaterialsList(new \StructType\Context(), new \StructType\MOOperationKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoMaterialsListNext operation/method
 */
if ($get->GetRelatedMoMaterialsListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOComponent operation/method
 */
if ($get->GetMOComponent(new \StructType\Context(), new \StructType\MOComponentKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOComponentList operation/method
 */
if ($get->GetMOComponentList(new \StructType\Context(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMOComponentListNext operation/method
 */
if ($get->GetMOComponentListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZ106338AT679193215272AAAAAAAAAF9List operation/method
 */
if ($get->GetZ106338AT679193215272AAAAAAAAAF9List(new \StructType\Context(), new \StructType\MOComponentKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZ106338AT679193215272AAAAAAAAAF9ListNext operation/method
 */
if ($get->GetZ106338AT679193215272AAAAAAAAAF9ListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedManufacturingOrder_f7a734560d234aa84aafc5706a5de218
 * operation/method
 */
if ($get->GetRelatedManufacturingOrder_f7a734560d234aa84aafc5706a5de218(new \StructType\Context(), new \StructType\MOComponentKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoOperation operation/method
 */
if ($get->GetRelatedMoOperation(new \StructType\Context(), new \StructType\MOComponentKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetManufacturingOrder operation/method
 */
if ($get->GetManufacturingOrder(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetManufacturingOrderList operation/method
 */
if ($get->GetManufacturingOrderList(new \StructType\Context(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetManufacturingOrderListNext operation/method
 */
if ($get->GetManufacturingOrderListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZ106338AT941112215352AAAAAAAAAFI operation/method
 */
if ($get->GetZ106338AT941112215352AAAAAAAAAFI(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedComponentMOsList operation/method
 */
if ($get->GetRelatedComponentMOsList(new \StructType\Context(), new \StructType\ManufacturingOrderKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedComponentMOsListNext operation/method
 */
if ($get->GetRelatedComponentMOsListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedManufacturingOrder_65513b6dc54122b69c6fa0a7ca1a5481
 * operation/method
 */
if ($get->GetRelatedManufacturingOrder_65513b6dc54122b69c6fa0a7ca1a5481(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMfgDemand operation/method
 */
if ($get->GetRelatedMfgDemand(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMfgDemandTopLevel operation/method
 */
if ($get->GetRelatedMfgDemandTopLevel(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoMaterialsList_efb46d61b9c599ef69e186fee2f86ef7
 * operation/method
 */
if ($get->GetRelatedMoMaterialsList_efb46d61b9c599ef69e186fee2f86ef7(new \StructType\Context(), new \StructType\ManufacturingOrderKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoOperation_65513b6dc54122b69c6fa0a7ca1a5481
 * operation/method
 */
if ($get->GetRelatedMoOperation_65513b6dc54122b69c6fa0a7ca1a5481(new \StructType\Context(), new \StructType\ManufacturingOrderKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoOperationsList operation/method
 */
if ($get->GetRelatedMoOperationsList(new \StructType\Context(), new \StructType\ManufacturingOrderKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedMoOperationsListNext operation/method
 */
if ($get->GetRelatedMoOperationsListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedSplitsList operation/method
 */
if ($get->GetRelatedSplitsList(new \StructType\Context(), new \StructType\ManufacturingOrderKey(), new \StructType\ViewDfn(), new \StructType\SortDfn(), new \StructType\SubsetDfn(), $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedSplitsListNext operation/method
 */
if ($get->GetRelatedSplitsListNext(new \StructType\Context(), $queryName, $maxReturned) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateComment operation/method
 */
if ($update->UpdateComment(new \StructType\Context(), new \StructType\Comment(), $commentAction, $commentText, $reasonCode) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangeMOOperation operation/method
 */
if ($change->ChangeMOOperation(new \StructType\Context(), new \StructType\MOOperation(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeMOComponent operation/method
 */
if ($change->ChangeMOComponent(new \StructType\Context(), new \StructType\MOComponent(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeManufacturingOrder operation/method
 */
if ($change->ChangeManufacturingOrder(new \StructType\Context(), new \StructType\ManufacturingOrder(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \ServiceType\Copy($options);
/**
 * Sample call for CopyMOOperation operation/method
 */
if ($copy->CopyMOOperation(new \StructType\Context(), new \StructType\MOOperationKey(), new \StructType\MOOperation(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Sample call for CopyMOComponent operation/method
 */
if ($copy->CopyMOComponent(new \StructType\Context(), new \StructType\MOComponentKey(), new \StructType\MOComponent(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Sample call for CopyManufacturingOrder operation/method
 */
if ($copy->CopyManufacturingOrder(new \StructType\Context(), new \StructType\ManufacturingOrderKey(), new \StructType\ManufacturingOrder(), new \ArrayType\ArrayOfMOComponent(), new \ArrayType\ArrayOfMOOperation(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateMOOperation operation/method
 */
if ($create->CreateMOOperation(new \StructType\Context(), new \StructType\MOOperation(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMOComponent operation/method
 */
if ($create->CreateMOComponent(new \StructType\Context(), new \StructType\MOComponent(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateManufacturingOrder operation/method
 */
if ($create->CreateManufacturingOrder(new \StructType\Context(), new \StructType\ManufacturingOrder(), new \ArrayType\ArrayOfMOComponent(), new \ArrayType\ArrayOfMOOperation(), $reasonCode, new \StructType\TemplateDfn()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteMOOperation operation/method
 */
if ($delete->DeleteMOOperation(new \StructType\Context(), new \StructType\MOOperationKey(), $reasonCode) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMOComponent operation/method
 */
if ($delete->DeleteMOComponent(new \StructType\Context(), new \StructType\MOComponentKey(), $reasonCode) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
