<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubsetDfn StructType
 * @subpackage Structs
 */
class SubsetDfn extends AbstractStructBase
{
    /**
     * The objectId
     * @var string
     */
    public $objectId;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The userId
     * @var string
     */
    public $userId;
    /**
     * The promptedValues
     * @var \ArrayType\ArrayOfPromptedValue
     */
    public $promptedValues;
    /**
     * Constructor method for SubsetDfn
     * @uses SubsetDfn::setObjectId()
     * @uses SubsetDfn::setTitle()
     * @uses SubsetDfn::setUserId()
     * @uses SubsetDfn::setPromptedValues()
     * @param string $objectId
     * @param string $title
     * @param string $userId
     * @param \ArrayType\ArrayOfPromptedValue $promptedValues
     */
    public function __construct($objectId = null, $title = null, $userId = null, \ArrayType\ArrayOfPromptedValue $promptedValues = null)
    {
        $this
            ->setObjectId($objectId)
            ->setTitle($title)
            ->setUserId($userId)
            ->setPromptedValues($promptedValues);
    }
    /**
     * Get objectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param string $objectId
     * @return \StructType\SubsetDfn
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\SubsetDfn
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\SubsetDfn
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get promptedValues value
     * @return \ArrayType\ArrayOfPromptedValue|null
     */
    public function getPromptedValues()
    {
        return $this->promptedValues;
    }
    /**
     * Set promptedValues value
     * @param \ArrayType\ArrayOfPromptedValue $promptedValues
     * @return \StructType\SubsetDfn
     */
    public function setPromptedValues(\ArrayType\ArrayOfPromptedValue $promptedValues = null)
    {
        $this->promptedValues = $promptedValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubsetDfn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
