<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReasonCode StructType
 * @subpackage Structs
 */
class ReasonCode extends AbstractStructBase
{
    /**
     * The reasonCode
     * @var string
     */
    public $reasonCode;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * Constructor method for ReasonCode
     * @uses ReasonCode::setReasonCode()
     * @uses ReasonCode::setDescription()
     * @param string $reasonCode
     * @param string $description
     */
    public function __construct($reasonCode = null, $description = null)
    {
        $this
            ->setReasonCode($reasonCode)
            ->setDescription($description);
    }
    /**
     * Get reasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->reasonCode;
    }
    /**
     * Set reasonCode value
     * @param string $reasonCode
     * @return \StructType\ReasonCode
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->reasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ReasonCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReasonCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
