<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainObject StructType
 * @subpackage Structs
 */
class DomainObject extends AbstractStructBase
{
    /**
     * The key
     * @var \StructType\DomainKey
     */
    public $key;
    /**
     * The properties
     * @var \ArrayType\ArrayOfProperty
     */
    public $properties;
    /**
     * Constructor method for DomainObject
     * @uses DomainObject::setKey()
     * @uses DomainObject::setProperties()
     * @param \StructType\DomainKey $key
     * @param \ArrayType\ArrayOfProperty $properties
     */
    public function __construct(\StructType\DomainKey $key = null, \ArrayType\ArrayOfProperty $properties = null)
    {
        $this
            ->setKey($key)
            ->setProperties($properties);
    }
    /**
     * Get key value
     * @return \StructType\DomainKey|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param \StructType\DomainKey $key
     * @return \StructType\DomainObject
     */
    public function setKey(\StructType\DomainKey $key = null)
    {
        $this->key = $key;
        return $this;
    }
    /**
     * Get properties value
     * @return \ArrayType\ArrayOfProperty|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @param \ArrayType\ArrayOfProperty $properties
     * @return \StructType\DomainObject
     */
    public function setProperties(\ArrayType\ArrayOfProperty $properties = null)
    {
        $this->properties = $properties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
