<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateResponse StructType
 * @subpackage Structs
 */
class CreateResponse extends AbstractStructBase
{
    /**
     * The context
     * @var \StructType\Context
     */
    public $context;
    /**
     * The successful
     * @var bool
     */
    public $successful;
    /**
     * The key
     * @var \StructType\DomainKey
     */
    public $key;
    /**
     * The messages
     * @var \ArrayType\ArrayOfUserMessage
     */
    public $messages;
    /**
     * Constructor method for CreateResponse
     * @uses CreateResponse::setContext()
     * @uses CreateResponse::setSuccessful()
     * @uses CreateResponse::setKey()
     * @uses CreateResponse::setMessages()
     * @param \StructType\Context $context
     * @param bool $successful
     * @param \StructType\DomainKey $key
     * @param \ArrayType\ArrayOfUserMessage $messages
     */
    public function __construct(\StructType\Context $context = null, $successful = null, \StructType\DomainKey $key = null, \ArrayType\ArrayOfUserMessage $messages = null)
    {
        $this
            ->setContext($context)
            ->setSuccessful($successful)
            ->setKey($key)
            ->setMessages($messages);
    }
    /**
     * Get context value
     * @return \StructType\Context|null
     */
    public function getContext()
    {
        return $this->context;
    }
    /**
     * Set context value
     * @param \StructType\Context $context
     * @return \StructType\CreateResponse
     */
    public function setContext(\StructType\Context $context = null)
    {
        $this->context = $context;
        return $this;
    }
    /**
     * Get successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->successful;
    }
    /**
     * Set successful value
     * @param bool $successful
     * @return \StructType\CreateResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->successful = $successful;
        return $this;
    }
    /**
     * Get key value
     * @return \StructType\DomainKey|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param \StructType\DomainKey $key
     * @return \StructType\CreateResponse
     */
    public function setKey(\StructType\DomainKey $key = null)
    {
        $this->key = $key;
        return $this;
    }
    /**
     * Get messages value
     * @return \ArrayType\ArrayOfUserMessage|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param \ArrayType\ArrayOfUserMessage $messages
     * @return \StructType\CreateResponse
     */
    public function setMessages(\ArrayType\ArrayOfUserMessage $messages = null)
    {
        $this->messages = $messages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
