<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Copy ServiceType
 * @subpackage Services
 */
class Copy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CopyMOOperation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $sourceKey
     * @param \StructType\MOOperation $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateMOOperationResponse|bool
     */
    public function CopyMOOperation(\StructType\Context $context, \StructType\MOOperationKey $sourceKey, \StructType\MOOperation $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CopyMOOperation($context, $sourceKey, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CopyMOComponent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $sourceKey
     * @param \StructType\MOComponent $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateMOComponentResponse|bool
     */
    public function CopyMOComponent(\StructType\Context $context, \StructType\MOComponentKey $sourceKey, \StructType\MOComponent $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CopyMOComponent($context, $sourceKey, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CopyManufacturingOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $sourceKey
     * @param \StructType\ManufacturingOrder $domainObject
     * @param \ArrayType\ArrayOfMOComponent $relatedMoMaterials
     * @param \ArrayType\ArrayOfMOOperation $relatedMoOperations
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateManufacturingOrderResponse|bool
     */
    public function CopyManufacturingOrder(\StructType\Context $context, \StructType\ManufacturingOrderKey $sourceKey, \StructType\ManufacturingOrder $domainObject, \ArrayType\ArrayOfMOComponent $relatedMoMaterials, \ArrayType\ArrayOfMOOperation $relatedMoOperations, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CopyManufacturingOrder($context, $sourceKey, $domainObject, $relatedMoMaterials, $relatedMoOperations, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateManufacturingOrderResponse|\StructType\CreateMOComponentResponse|\StructType\CreateMOOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
