<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeMOOperation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperation $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\MaintenanceResponse|bool
     */
    public function ChangeMOOperation(\StructType\Context $context, \StructType\MOOperation $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeMOOperation($context, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeMOComponent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponent $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\MaintenanceResponse|bool
     */
    public function ChangeMOComponent(\StructType\Context $context, \StructType\MOComponent $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeMOComponent($context, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeManufacturingOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrder $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\MaintenanceResponse|bool
     */
    public function ChangeManufacturingOrder(\StructType\Context $context, \StructType\ManufacturingOrder $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeManufacturingOrder($context, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MaintenanceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
