<?php

namespace EnumType;

/**
 * This class stands for CustomDfnSecurity EnumType
 * @subpackage Enumerations
 */
class CustomDfnSecurity
{
    /**
     * Constant for value 'public'
     * @return string 'public'
     */
    const VALUE_PUBLIC = 'public';
    /**
     * Constant for value 'private'
     * @return string 'private'
     */
    const VALUE_PRIVATE = 'private';
    /**
     * Constant for value 'both'
     * @return string 'both'
     */
    const VALUE_BOTH = 'both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PUBLIC
     * @uses self::VALUE_PRIVATE
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PUBLIC,
            self::VALUE_PRIVATE,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
