<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Context' => '\\StructType\\Context',
            'DomainClassInfo' => '\\StructType\\DomainClassInfo',
            'ArrayOfPropertyInfo' => '\\ArrayType\\ArrayOfPropertyInfo',
            'PropertyInfo' => '\\StructType\\PropertyInfo',
            'MaintenanceResponse' => '\\StructType\\MaintenanceResponse',
            'LogoutResponse' => '\\StructType\\LogoutResponse',
            'ArrayOfUserMessage' => '\\ArrayType\\ArrayOfUserMessage',
            'UserMessage' => '\\StructType\\UserMessage',
            'LoginResponse' => '\\StructType\\LoginResponse',
            'ArrayOfString' => '\\ArrayType\\ArrayOfString',
            'ArrayOfViewDfn' => '\\ArrayType\\ArrayOfViewDfn',
            'ArrayOfSortDfn' => '\\ArrayType\\ArrayOfSortDfn',
            'ArrayOfSubsetDfn' => '\\ArrayType\\ArrayOfSubsetDfn',
            'ArrayOfPromptedValue' => '\\ArrayType\\ArrayOfPromptedValue',
            'ArrayOfTemplateDfn' => '\\ArrayType\\ArrayOfTemplateDfn',
            'PromptedValue' => '\\StructType\\PromptedValue',
            'ViewDfn' => '\\StructType\\ViewDfn',
            'TemplateDfn' => '\\StructType\\TemplateDfn',
            'SubsetDfn' => '\\StructType\\SubsetDfn',
            'SortDfn' => '\\StructType\\SortDfn',
            'ArrayOfReasonCode' => '\\ArrayType\\ArrayOfReasonCode',
            'ReasonCode' => '\\StructType\\ReasonCode',
            'ArrayOfComment' => '\\ArrayType\\ArrayOfComment',
            'Comment' => '\\StructType\\Comment',
            'GetMoreCommentTextResponse' => '\\StructType\\GetMoreCommentTextResponse',
            'ArrayOfProperty' => '\\ArrayType\\ArrayOfProperty',
            'Property' => '\\StructType\\Property',
            'DomainKey' => '\\StructType\\DomainKey',
            'ArrayOfDomainObject' => '\\ArrayType\\ArrayOfDomainObject',
            'DomainObject' => '\\StructType\\DomainObject',
            'GetListResponse' => '\\StructType\\GetListResponse',
            'GetObjectResponse' => '\\StructType\\GetObjectResponse',
            'CreateResponse' => '\\StructType\\CreateResponse',
            'ArrayOfMOOperationKey' => '\\ArrayType\\ArrayOfMOOperationKey',
            'ArrayOfMOOperation' => '\\ArrayType\\ArrayOfMOOperation',
            'MOOperationKey' => '\\StructType\\MOOperationKey',
            'MOOperation' => '\\StructType\\MOOperation',
            'GetMOOperationResponse' => '\\StructType\\GetMOOperationResponse',
            'GetMOOperationListResponse' => '\\StructType\\GetMOOperationListResponse',
            'CreateMOOperationResponse' => '\\StructType\\CreateMOOperationResponse',
            'ArrayOfMOComponentKey' => '\\ArrayType\\ArrayOfMOComponentKey',
            'ArrayOfMOComponent' => '\\ArrayType\\ArrayOfMOComponent',
            'MOComponentKey' => '\\StructType\\MOComponentKey',
            'MOComponent' => '\\StructType\\MOComponent',
            'GetMOComponentResponse' => '\\StructType\\GetMOComponentResponse',
            'GetMOComponentListResponse' => '\\StructType\\GetMOComponentListResponse',
            'CreateMOComponentResponse' => '\\StructType\\CreateMOComponentResponse',
            'ArrayOfManufacturingOrderKey' => '\\ArrayType\\ArrayOfManufacturingOrderKey',
            'ArrayOfManufacturingOrder' => '\\ArrayType\\ArrayOfManufacturingOrder',
            'ManufacturingOrderKey' => '\\StructType\\ManufacturingOrderKey',
            'ManufacturingOrder' => '\\StructType\\ManufacturingOrder',
            'GetManufacturingOrderResponse' => '\\StructType\\GetManufacturingOrderResponse',
            'GetManufacturingOrderListResponse' => '\\StructType\\GetManufacturingOrderListResponse',
            'CreateManufacturingOrderResponse' => '\\StructType\\CreateManufacturingOrderResponse',
        );
    }
}
