<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyInfo StructType
 * @subpackage Structs
 */
class PropertyInfo extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The deployedName
     * @var string
     */
    public $deployedName;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The canCreate
     * @var bool
     */
    public $canCreate;
    /**
     * The canUpdate
     * @var bool
     */
    public $canUpdate;
    /**
     * The isKeyProperty
     * @var bool
     */
    public $isKeyProperty;
    /**
     * The format
     * @var string
     */
    public $format;
    /**
     * Constructor method for PropertyInfo
     * @uses PropertyInfo::setName()
     * @uses PropertyInfo::setDeployedName()
     * @uses PropertyInfo::setDescription()
     * @uses PropertyInfo::setCanCreate()
     * @uses PropertyInfo::setCanUpdate()
     * @uses PropertyInfo::setIsKeyProperty()
     * @uses PropertyInfo::setFormat()
     * @param string $name
     * @param string $deployedName
     * @param string $description
     * @param bool $canCreate
     * @param bool $canUpdate
     * @param bool $isKeyProperty
     * @param string $format
     */
    public function __construct($name = null, $deployedName = null, $description = null, $canCreate = null, $canUpdate = null, $isKeyProperty = null, $format = null)
    {
        $this
            ->setName($name)
            ->setDeployedName($deployedName)
            ->setDescription($description)
            ->setCanCreate($canCreate)
            ->setCanUpdate($canUpdate)
            ->setIsKeyProperty($isKeyProperty)
            ->setFormat($format);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PropertyInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get deployedName value
     * @return string|null
     */
    public function getDeployedName()
    {
        return $this->deployedName;
    }
    /**
     * Set deployedName value
     * @param string $deployedName
     * @return \StructType\PropertyInfo
     */
    public function setDeployedName($deployedName = null)
    {
        // validation for constraint: string
        if (!is_null($deployedName) && !is_string($deployedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deployedName, true), gettype($deployedName)), __LINE__);
        }
        $this->deployedName = $deployedName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PropertyInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get canCreate value
     * @return bool|null
     */
    public function getCanCreate()
    {
        return $this->canCreate;
    }
    /**
     * Set canCreate value
     * @param bool $canCreate
     * @return \StructType\PropertyInfo
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        $this->canCreate = $canCreate;
        return $this;
    }
    /**
     * Get canUpdate value
     * @return bool|null
     */
    public function getCanUpdate()
    {
        return $this->canUpdate;
    }
    /**
     * Set canUpdate value
     * @param bool $canUpdate
     * @return \StructType\PropertyInfo
     */
    public function setCanUpdate($canUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUpdate) && !is_bool($canUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUpdate, true), gettype($canUpdate)), __LINE__);
        }
        $this->canUpdate = $canUpdate;
        return $this;
    }
    /**
     * Get isKeyProperty value
     * @return bool|null
     */
    public function getIsKeyProperty()
    {
        return $this->isKeyProperty;
    }
    /**
     * Set isKeyProperty value
     * @param bool $isKeyProperty
     * @return \StructType\PropertyInfo
     */
    public function setIsKeyProperty($isKeyProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKeyProperty) && !is_bool($isKeyProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKeyProperty, true), gettype($isKeyProperty)), __LINE__);
        }
        $this->isKeyProperty = $isKeyProperty;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \EnumType\PropertyFormat::valueIsValid()
     * @uses \EnumType\PropertyFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\PropertyInfo
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PropertyFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PropertyFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\PropertyFormat::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
