<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListResponse StructType
 * @subpackage Structs
 */
class GetListResponse extends AbstractStructBase
{
    /**
     * The context
     * @var \StructType\Context
     */
    public $context;
    /**
     * The successful
     * @var bool
     */
    public $successful;
    /**
     * The hasMoreElements
     * @var bool
     */
    public $hasMoreElements;
    /**
     * The queryName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $queryName;
    /**
     * The domainObjects
     * @var \ArrayType\ArrayOfDomainObject
     */
    public $domainObjects;
    /**
     * The messages
     * @var \ArrayType\ArrayOfUserMessage
     */
    public $messages;
    /**
     * Constructor method for GetListResponse
     * @uses GetListResponse::setContext()
     * @uses GetListResponse::setSuccessful()
     * @uses GetListResponse::setHasMoreElements()
     * @uses GetListResponse::setQueryName()
     * @uses GetListResponse::setDomainObjects()
     * @uses GetListResponse::setMessages()
     * @param \StructType\Context $context
     * @param bool $successful
     * @param bool $hasMoreElements
     * @param string $queryName
     * @param \ArrayType\ArrayOfDomainObject $domainObjects
     * @param \ArrayType\ArrayOfUserMessage $messages
     */
    public function __construct(\StructType\Context $context = null, $successful = null, $hasMoreElements = null, $queryName = null, \ArrayType\ArrayOfDomainObject $domainObjects = null, \ArrayType\ArrayOfUserMessage $messages = null)
    {
        $this
            ->setContext($context)
            ->setSuccessful($successful)
            ->setHasMoreElements($hasMoreElements)
            ->setQueryName($queryName)
            ->setDomainObjects($domainObjects)
            ->setMessages($messages);
    }
    /**
     * Get context value
     * @return \StructType\Context|null
     */
    public function getContext()
    {
        return $this->context;
    }
    /**
     * Set context value
     * @param \StructType\Context $context
     * @return \StructType\GetListResponse
     */
    public function setContext(\StructType\Context $context = null)
    {
        $this->context = $context;
        return $this;
    }
    /**
     * Get successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->successful;
    }
    /**
     * Set successful value
     * @param bool $successful
     * @return \StructType\GetListResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->successful = $successful;
        return $this;
    }
    /**
     * Get hasMoreElements value
     * @return bool|null
     */
    public function getHasMoreElements()
    {
        return $this->hasMoreElements;
    }
    /**
     * Set hasMoreElements value
     * @param bool $hasMoreElements
     * @return \StructType\GetListResponse
     */
    public function setHasMoreElements($hasMoreElements = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreElements) && !is_bool($hasMoreElements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMoreElements, true), gettype($hasMoreElements)), __LINE__);
        }
        $this->hasMoreElements = $hasMoreElements;
        return $this;
    }
    /**
     * Get queryName value
     * @return string|null
     */
    public function getQueryName()
    {
        return $this->queryName;
    }
    /**
     * Set queryName value
     * @param string $queryName
     * @return \StructType\GetListResponse
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        $this->queryName = $queryName;
        return $this;
    }
    /**
     * Get domainObjects value
     * @return \ArrayType\ArrayOfDomainObject|null
     */
    public function getDomainObjects()
    {
        return $this->domainObjects;
    }
    /**
     * Set domainObjects value
     * @param \ArrayType\ArrayOfDomainObject $domainObjects
     * @return \StructType\GetListResponse
     */
    public function setDomainObjects(\ArrayType\ArrayOfDomainObject $domainObjects = null)
    {
        $this->domainObjects = $domainObjects;
        return $this;
    }
    /**
     * Get messages value
     * @return \ArrayType\ArrayOfUserMessage|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param \ArrayType\ArrayOfUserMessage $messages
     * @return \StructType\GetListResponse
     */
    public function setMessages(\ArrayType\ArrayOfUserMessage $messages = null)
    {
        $this->messages = $messages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
