<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainKey StructType
 * @subpackage Structs
 */
class DomainKey extends AbstractStructBase
{
    /**
     * The domainClass
     * @var string
     */
    public $domainClass;
    /**
     * The properties
     * @var \ArrayType\ArrayOfProperty
     */
    public $properties;
    /**
     * Constructor method for DomainKey
     * @uses DomainKey::setDomainClass()
     * @uses DomainKey::setProperties()
     * @param string $domainClass
     * @param \ArrayType\ArrayOfProperty $properties
     */
    public function __construct($domainClass = null, \ArrayType\ArrayOfProperty $properties = null)
    {
        $this
            ->setDomainClass($domainClass)
            ->setProperties($properties);
    }
    /**
     * Get domainClass value
     * @return string|null
     */
    public function getDomainClass()
    {
        return $this->domainClass;
    }
    /**
     * Set domainClass value
     * @param string $domainClass
     * @return \StructType\DomainKey
     */
    public function setDomainClass($domainClass = null)
    {
        // validation for constraint: string
        if (!is_null($domainClass) && !is_string($domainClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainClass, true), gettype($domainClass)), __LINE__);
        }
        $this->domainClass = $domainClass;
        return $this;
    }
    /**
     * Get properties value
     * @return \ArrayType\ArrayOfProperty|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @param \ArrayType\ArrayOfProperty $properties
     * @return \StructType\DomainKey
     */
    public function setProperties(\ArrayType\ArrayOfProperty $properties = null)
    {
        $this->properties = $properties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainKey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
