<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainClassInfo StructType
 * @subpackage Structs
 */
class DomainClassInfo extends AbstractStructBase
{
    /**
     * The domainClass
     * @var string
     */
    public $domainClass;
    /**
     * The keyProperties
     * @var \ArrayType\ArrayOfPropertyInfo
     */
    public $keyProperties;
    /**
     * The properties
     * @var \ArrayType\ArrayOfPropertyInfo
     */
    public $properties;
    /**
     * The listTitle
     * @var string
     */
    public $listTitle;
    /**
     * The formTitle
     * @var string
     */
    public $formTitle;
    /**
     * The classMnemonic
     * @var string
     */
    public $classMnemonic;
    /**
     * Constructor method for DomainClassInfo
     * @uses DomainClassInfo::setDomainClass()
     * @uses DomainClassInfo::setKeyProperties()
     * @uses DomainClassInfo::setProperties()
     * @uses DomainClassInfo::setListTitle()
     * @uses DomainClassInfo::setFormTitle()
     * @uses DomainClassInfo::setClassMnemonic()
     * @param string $domainClass
     * @param \ArrayType\ArrayOfPropertyInfo $keyProperties
     * @param \ArrayType\ArrayOfPropertyInfo $properties
     * @param string $listTitle
     * @param string $formTitle
     * @param string $classMnemonic
     */
    public function __construct($domainClass = null, \ArrayType\ArrayOfPropertyInfo $keyProperties = null, \ArrayType\ArrayOfPropertyInfo $properties = null, $listTitle = null, $formTitle = null, $classMnemonic = null)
    {
        $this
            ->setDomainClass($domainClass)
            ->setKeyProperties($keyProperties)
            ->setProperties($properties)
            ->setListTitle($listTitle)
            ->setFormTitle($formTitle)
            ->setClassMnemonic($classMnemonic);
    }
    /**
     * Get domainClass value
     * @return string|null
     */
    public function getDomainClass()
    {
        return $this->domainClass;
    }
    /**
     * Set domainClass value
     * @param string $domainClass
     * @return \StructType\DomainClassInfo
     */
    public function setDomainClass($domainClass = null)
    {
        // validation for constraint: string
        if (!is_null($domainClass) && !is_string($domainClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainClass, true), gettype($domainClass)), __LINE__);
        }
        $this->domainClass = $domainClass;
        return $this;
    }
    /**
     * Get keyProperties value
     * @return \ArrayType\ArrayOfPropertyInfo|null
     */
    public function getKeyProperties()
    {
        return $this->keyProperties;
    }
    /**
     * Set keyProperties value
     * @param \ArrayType\ArrayOfPropertyInfo $keyProperties
     * @return \StructType\DomainClassInfo
     */
    public function setKeyProperties(\ArrayType\ArrayOfPropertyInfo $keyProperties = null)
    {
        $this->keyProperties = $keyProperties;
        return $this;
    }
    /**
     * Get properties value
     * @return \ArrayType\ArrayOfPropertyInfo|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @param \ArrayType\ArrayOfPropertyInfo $properties
     * @return \StructType\DomainClassInfo
     */
    public function setProperties(\ArrayType\ArrayOfPropertyInfo $properties = null)
    {
        $this->properties = $properties;
        return $this;
    }
    /**
     * Get listTitle value
     * @return string|null
     */
    public function getListTitle()
    {
        return $this->listTitle;
    }
    /**
     * Set listTitle value
     * @param string $listTitle
     * @return \StructType\DomainClassInfo
     */
    public function setListTitle($listTitle = null)
    {
        // validation for constraint: string
        if (!is_null($listTitle) && !is_string($listTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listTitle, true), gettype($listTitle)), __LINE__);
        }
        $this->listTitle = $listTitle;
        return $this;
    }
    /**
     * Get formTitle value
     * @return string|null
     */
    public function getFormTitle()
    {
        return $this->formTitle;
    }
    /**
     * Set formTitle value
     * @param string $formTitle
     * @return \StructType\DomainClassInfo
     */
    public function setFormTitle($formTitle = null)
    {
        // validation for constraint: string
        if (!is_null($formTitle) && !is_string($formTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formTitle, true), gettype($formTitle)), __LINE__);
        }
        $this->formTitle = $formTitle;
        return $this;
    }
    /**
     * Get classMnemonic value
     * @return string|null
     */
    public function getClassMnemonic()
    {
        return $this->classMnemonic;
    }
    /**
     * Set classMnemonic value
     * @param string $classMnemonic
     * @return \StructType\DomainClassInfo
     */
    public function setClassMnemonic($classMnemonic = null)
    {
        // validation for constraint: string
        if (!is_null($classMnemonic) && !is_string($classMnemonic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classMnemonic, true), gettype($classMnemonic)), __LINE__);
        }
        $this->classMnemonic = $classMnemonic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainClassInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
