<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Context StructType
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The sessionHandle
     * @var string
     */
    public $sessionHandle;
    /**
     * The workHandle
     * @var string
     */
    public $workHandle;
    /**
     * The requestIdleTime
     * @var int
     */
    public $requestIdleTime;
    /**
     * Constructor method for Context
     * @uses Context::setSessionHandle()
     * @uses Context::setWorkHandle()
     * @uses Context::setRequestIdleTime()
     * @param string $sessionHandle
     * @param string $workHandle
     * @param int $requestIdleTime
     */
    public function __construct($sessionHandle = null, $workHandle = null, $requestIdleTime = null)
    {
        $this
            ->setSessionHandle($sessionHandle)
            ->setWorkHandle($workHandle)
            ->setRequestIdleTime($requestIdleTime);
    }
    /**
     * Get sessionHandle value
     * @return string|null
     */
    public function getSessionHandle()
    {
        return $this->sessionHandle;
    }
    /**
     * Set sessionHandle value
     * @param string $sessionHandle
     * @return \StructType\Context
     */
    public function setSessionHandle($sessionHandle = null)
    {
        // validation for constraint: string
        if (!is_null($sessionHandle) && !is_string($sessionHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionHandle, true), gettype($sessionHandle)), __LINE__);
        }
        $this->sessionHandle = $sessionHandle;
        return $this;
    }
    /**
     * Get workHandle value
     * @return string|null
     */
    public function getWorkHandle()
    {
        return $this->workHandle;
    }
    /**
     * Set workHandle value
     * @param string $workHandle
     * @return \StructType\Context
     */
    public function setWorkHandle($workHandle = null)
    {
        // validation for constraint: string
        if (!is_null($workHandle) && !is_string($workHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workHandle, true), gettype($workHandle)), __LINE__);
        }
        $this->workHandle = $workHandle;
        return $this;
    }
    /**
     * Get requestIdleTime value
     * @return int|null
     */
    public function getRequestIdleTime()
    {
        return $this->requestIdleTime;
    }
    /**
     * Set requestIdleTime value
     * @param int $requestIdleTime
     * @return \StructType\Context
     */
    public function setRequestIdleTime($requestIdleTime = null)
    {
        // validation for constraint: int
        if (!is_null($requestIdleTime) && !(is_int($requestIdleTime) || ctype_digit($requestIdleTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestIdleTime, true), gettype($requestIdleTime)), __LINE__);
        }
        $this->requestIdleTime = $requestIdleTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Context
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
