<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @subpackage Structs
 */
class Comment extends AbstractStructBase
{
    /**
     * The objectKey
     * @var \StructType\DomainKey
     */
    public $objectKey;
    /**
     * The queryName
     * @var string
     */
    public $queryName;
    /**
     * The relationshipName
     * @var string
     */
    public $relationshipName;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The commentType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $commentType;
    /**
     * The typeDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeDescription;
    /**
     * The hasMoreText
     * @var bool
     */
    public $hasMoreText;
    /**
     * The text
     * @var string
     */
    public $text;
    /**
     * Constructor method for Comment
     * @uses Comment::setObjectKey()
     * @uses Comment::setQueryName()
     * @uses Comment::setRelationshipName()
     * @uses Comment::setDescription()
     * @uses Comment::setCommentType()
     * @uses Comment::setTypeDescription()
     * @uses Comment::setHasMoreText()
     * @uses Comment::setText()
     * @param \StructType\DomainKey $objectKey
     * @param string $queryName
     * @param string $relationshipName
     * @param string $description
     * @param string $commentType
     * @param string $typeDescription
     * @param bool $hasMoreText
     * @param string $text
     */
    public function __construct(\StructType\DomainKey $objectKey = null, $queryName = null, $relationshipName = null, $description = null, $commentType = null, $typeDescription = null, $hasMoreText = null, $text = null)
    {
        $this
            ->setObjectKey($objectKey)
            ->setQueryName($queryName)
            ->setRelationshipName($relationshipName)
            ->setDescription($description)
            ->setCommentType($commentType)
            ->setTypeDescription($typeDescription)
            ->setHasMoreText($hasMoreText)
            ->setText($text);
    }
    /**
     * Get objectKey value
     * @return \StructType\DomainKey|null
     */
    public function getObjectKey()
    {
        return $this->objectKey;
    }
    /**
     * Set objectKey value
     * @param \StructType\DomainKey $objectKey
     * @return \StructType\Comment
     */
    public function setObjectKey(\StructType\DomainKey $objectKey = null)
    {
        $this->objectKey = $objectKey;
        return $this;
    }
    /**
     * Get queryName value
     * @return string|null
     */
    public function getQueryName()
    {
        return $this->queryName;
    }
    /**
     * Set queryName value
     * @param string $queryName
     * @return \StructType\Comment
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        $this->queryName = $queryName;
        return $this;
    }
    /**
     * Get relationshipName value
     * @return string|null
     */
    public function getRelationshipName()
    {
        return $this->relationshipName;
    }
    /**
     * Set relationshipName value
     * @param string $relationshipName
     * @return \StructType\Comment
     */
    public function setRelationshipName($relationshipName = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName) && !is_string($relationshipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipName, true), gettype($relationshipName)), __LINE__);
        }
        $this->relationshipName = $relationshipName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Comment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get commentType value
     * @return string|null
     */
    public function getCommentType()
    {
        return $this->commentType;
    }
    /**
     * Set commentType value
     * @param string $commentType
     * @return \StructType\Comment
     */
    public function setCommentType($commentType = null)
    {
        // validation for constraint: string
        if (!is_null($commentType) && !is_string($commentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentType, true), gettype($commentType)), __LINE__);
        }
        $this->commentType = $commentType;
        return $this;
    }
    /**
     * Get typeDescription value
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->typeDescription;
    }
    /**
     * Set typeDescription value
     * @param string $typeDescription
     * @return \StructType\Comment
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDescription, true), gettype($typeDescription)), __LINE__);
        }
        $this->typeDescription = $typeDescription;
        return $this;
    }
    /**
     * Get hasMoreText value
     * @return bool|null
     */
    public function getHasMoreText()
    {
        return $this->hasMoreText;
    }
    /**
     * Set hasMoreText value
     * @param bool $hasMoreText
     * @return \StructType\Comment
     */
    public function setHasMoreText($hasMoreText = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreText) && !is_bool($hasMoreText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMoreText, true), gettype($hasMoreText)), __LINE__);
        }
        $this->hasMoreText = $hasMoreText;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Comment
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Comment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
