<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateMOOperation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperation $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateMOOperationResponse|bool
     */
    public function CreateMOOperation(\StructType\Context $context, \StructType\MOOperation $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateMOOperation($context, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMOComponent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponent $domainObject
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateMOComponentResponse|bool
     */
    public function CreateMOComponent(\StructType\Context $context, \StructType\MOComponent $domainObject, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateMOComponent($context, $domainObject, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateManufacturingOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrder $domainObject
     * @param \ArrayType\ArrayOfMOComponent $relatedMoMaterials
     * @param \ArrayType\ArrayOfMOOperation $relatedMoOperations
     * @param string $reasonCode
     * @param \StructType\TemplateDfn $templateDfn
     * @return \StructType\CreateManufacturingOrderResponse|bool
     */
    public function CreateManufacturingOrder(\StructType\Context $context, \StructType\ManufacturingOrder $domainObject, \ArrayType\ArrayOfMOComponent $relatedMoMaterials, \ArrayType\ArrayOfMOOperation $relatedMoOperations, $reasonCode, \StructType\TemplateDfn $templateDfn)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateManufacturingOrder($context, $domainObject, $relatedMoMaterials, $relatedMoOperations, $reasonCode, $templateDfn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateManufacturingOrderResponse|\StructType\CreateMOComponentResponse|\StructType\CreateMOOperationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
