<?php

namespace EnumType;

/**
 * This class stands for TemplateType EnumType
 * @subpackage Enumerations
 */
class TemplateType
{
    /**
     * Constant for value 'create'
     * @return string 'create'
     */
    const VALUE_CREATE = 'create';
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'copy'
     * @return string 'copy'
     */
    const VALUE_COPY = 'copy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATE
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_COPY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATE,
            self::VALUE_UPDATE,
            self::VALUE_COPY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
