<?php

namespace EnumType;

/**
 * This class stands for PropertyFormat EnumType
 * @subpackage Enumerations
 */
class PropertyFormat
{
    /**
     * Constant for value 'string'
     * @return string 'string'
     */
    const VALUE_STRING = 'string';
    /**
     * Constant for value 'date'
     * @return string 'date'
     */
    const VALUE_DATE = 'date';
    /**
     * Constant for value 'time'
     * @return string 'time'
     */
    const VALUE_TIME = 'time';
    /**
     * Constant for value 'integer'
     * @return string 'integer'
     */
    const VALUE_INTEGER = 'integer';
    /**
     * Constant for value 'long'
     * @return string 'long'
     */
    const VALUE_LONG = 'long';
    /**
     * Constant for value 'short'
     * @return string 'short'
     */
    const VALUE_SHORT = 'short';
    /**
     * Constant for value 'decimal'
     * @return string 'decimal'
     */
    const VALUE_DECIMAL = 'decimal';
    /**
     * Constant for value 'float'
     * @return string 'float'
     */
    const VALUE_FLOAT = 'float';
    /**
     * Constant for value 'boolean'
     * @return string 'boolean'
     */
    const VALUE_BOOLEAN = 'boolean';
    /**
     * Constant for value 'hex'
     * @return string 'hex'
     */
    const VALUE_HEX = 'hex';
    /**
     * Constant for value 'timestamp'
     * @return string 'timestamp'
     */
    const VALUE_TIMESTAMP = 'timestamp';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_DATE
     * @uses self::VALUE_TIME
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_LONG
     * @uses self::VALUE_SHORT
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_FLOAT
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_HEX
     * @uses self::VALUE_TIMESTAMP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_DATE,
            self::VALUE_TIME,
            self::VALUE_INTEGER,
            self::VALUE_LONG,
            self::VALUE_SHORT,
            self::VALUE_DECIMAL,
            self::VALUE_FLOAT,
            self::VALUE_BOOLEAN,
            self::VALUE_HEX,
            self::VALUE_TIMESTAMP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
