<?php

namespace EnumType;

/**
 * This class stands for CommentActionType EnumType
 * @subpackage Enumerations
 */
class CommentActionType
{
    /**
     * Constant for value 'addToBeginning'
     * @return string 'addToBeginning'
     */
    const VALUE_ADD_TO_BEGINNING = 'addToBeginning';
    /**
     * Constant for value 'addToEnd'
     * @return string 'addToEnd'
     */
    const VALUE_ADD_TO_END = 'addToEnd';
    /**
     * Constant for value 'replace'
     * @return string 'replace'
     */
    const VALUE_REPLACE = 'replace';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_TO_BEGINNING
     * @uses self::VALUE_ADD_TO_END
     * @uses self::VALUE_REPLACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_TO_BEGINNING,
            self::VALUE_ADD_TO_END,
            self::VALUE_REPLACE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
