<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserMessage StructType
 * @subpackage Structs
 */
class UserMessage extends AbstractStructBase
{
    /**
     * The messageType
     * @var string
     */
    public $messageType;
    /**
     * The messageText
     * @var string
     */
    public $messageText;
    /**
     * The detailedText
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $detailedText;
    /**
     * Constructor method for UserMessage
     * @uses UserMessage::setMessageType()
     * @uses UserMessage::setMessageText()
     * @uses UserMessage::setDetailedText()
     * @param string $messageType
     * @param string $messageText
     * @param string $detailedText
     */
    public function __construct($messageType = null, $messageText = null, $detailedText = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageText($messageText)
            ->setDetailedText($detailedText);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @uses \EnumType\WarningType::valueIsValid()
     * @uses \EnumType\WarningType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\UserMessage
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WarningType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WarningType', is_array($messageType) ? implode(', ', $messageType) : var_export($messageType, true), implode(', ', \EnumType\WarningType::getValidValues())), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \StructType\UserMessage
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageText, true), gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get detailedText value
     * @return string|null
     */
    public function getDetailedText()
    {
        return $this->detailedText;
    }
    /**
     * Set detailedText value
     * @param string $detailedText
     * @return \StructType\UserMessage
     */
    public function setDetailedText($detailedText = null)
    {
        // validation for constraint: string
        if (!is_null($detailedText) && !is_string($detailedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailedText, true), gettype($detailedText)), __LINE__);
        }
        $this->detailedText = $detailedText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
