<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemplateDfn StructType
 * @subpackage Structs
 */
class TemplateDfn extends AbstractStructBase
{
    /**
     * The objectId
     * @var string
     */
    public $objectId;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The userId
     * @var string
     */
    public $userId;
    /**
     * The templateType
     * @var string
     */
    public $templateType;
    /**
     * Constructor method for TemplateDfn
     * @uses TemplateDfn::setObjectId()
     * @uses TemplateDfn::setTitle()
     * @uses TemplateDfn::setUserId()
     * @uses TemplateDfn::setTemplateType()
     * @param string $objectId
     * @param string $title
     * @param string $userId
     * @param string $templateType
     */
    public function __construct($objectId = null, $title = null, $userId = null, $templateType = null)
    {
        $this
            ->setObjectId($objectId)
            ->setTitle($title)
            ->setUserId($userId)
            ->setTemplateType($templateType);
    }
    /**
     * Get objectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param string $objectId
     * @return \StructType\TemplateDfn
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\TemplateDfn
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\TemplateDfn
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get templateType value
     * @return string|null
     */
    public function getTemplateType()
    {
        return $this->templateType;
    }
    /**
     * Set templateType value
     * @uses \EnumType\TemplateType::valueIsValid()
     * @uses \EnumType\TemplateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $templateType
     * @return \StructType\TemplateDfn
     */
    public function setTemplateType($templateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TemplateType::valueIsValid($templateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TemplateType', is_array($templateType) ? implode(', ', $templateType) : var_export($templateType, true), implode(', ', \EnumType\TemplateType::getValidValues())), __LINE__);
        }
        $this->templateType = $templateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemplateDfn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
