<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetMoreCommentText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\Comment $comment
     * @return \StructType\GetMoreCommentTextResponse|bool
     */
    public function GetMoreCommentText(\StructType\Context $context, \StructType\Comment $comment)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMoreCommentText($context, $comment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReasonCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \ArrayType\ArrayOfReasonCode|bool
     */
    public function GetReasonCodes(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReasonCodes($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOOperation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @return \StructType\GetMOOperationResponse|bool
     */
    public function GetMOOperation(\StructType\Context $context, \StructType\MOOperationKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOOperation($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetViewDfns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \ArrayType\ArrayOfViewDfn|bool
     */
    public function GetViewDfns(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetViewDfns($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSortDfns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \ArrayType\ArrayOfSortDfn|bool
     */
    public function GetSortDfns(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSortDfns($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubsetDfns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \ArrayType\ArrayOfSubsetDfn|bool
     */
    public function GetSubsetDfns(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSubsetDfns($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTemplateDfns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \ArrayType\ArrayOfTemplateDfn|bool
     */
    public function GetTemplateDfns(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTemplateDfns($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDomainClassInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @return \StructType\DomainClassInfo|bool
     */
    public function GetDomainClassInfo(\StructType\Context $context)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDomainClassInfo($context));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOOperationList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetMOOperationListResponse|bool
     */
    public function GetMOOperationList(\StructType\Context $context, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOOperationList($context, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOOperationListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetMOOperationListResponse|bool
     */
    public function GetMOOperationListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOOperationListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetZ106338AT941112215352AAAAAAAAADSList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetZ106338AT941112215352AAAAAAAAADSList(\StructType\Context $context, \StructType\MOOperationKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZ106338AT941112215352AAAAAAAAADSList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetZ106338AT941112215352AAAAAAAAADSListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetZ106338AT941112215352AAAAAAAAADSListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZ106338AT941112215352AAAAAAAAADSListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedManufacturingOrder
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetRelatedManufacturingOrder(\StructType\Context $context, \StructType\MOOperationKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedManufacturingOrder($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetRelatedManufacturingOrderSplitsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedManufacturingOrderSplitsList(\StructType\Context $context, \StructType\MOOperationKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedManufacturingOrderSplitsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetRelatedManufacturingOrderSplitsListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedManufacturingOrderSplitsListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedManufacturingOrderSplitsListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoMaterialsList
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetMOComponentListResponse|bool
     */
    public function GetRelatedMoMaterialsList(\StructType\Context $context, \StructType\MOOperationKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoMaterialsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoMaterialsListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetMOComponentListResponse|bool
     */
    public function GetRelatedMoMaterialsListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoMaterialsListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOComponent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $domainKey
     * @return \StructType\GetMOComponentResponse|bool
     */
    public function GetMOComponent(\StructType\Context $context, \StructType\MOComponentKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOComponent($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOComponentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetMOComponentListResponse|bool
     */
    public function GetMOComponentList(\StructType\Context $context, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOComponentList($context, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMOComponentListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetMOComponentListResponse|bool
     */
    public function GetMOComponentListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMOComponentListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetZ106338AT679193215272AAAAAAAAAF9List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetZ106338AT679193215272AAAAAAAAAF9List(\StructType\Context $context, \StructType\MOComponentKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZ106338AT679193215272AAAAAAAAAF9List($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetZ106338AT679193215272AAAAAAAAAF9ListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetZ106338AT679193215272AAAAAAAAAF9ListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZ106338AT679193215272AAAAAAAAAF9ListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedManufacturingOrder
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetRelatedManufacturingOrder_f7a734560d234aa84aafc5706a5de218(\StructType\Context $context, \StructType\MOComponentKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedManufacturingOrder($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoOperation
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $domainKey
     * @return \StructType\GetMOOperationResponse|bool
     */
    public function GetRelatedMoOperation(\StructType\Context $context, \StructType\MOComponentKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoOperation($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManufacturingOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetManufacturingOrder(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManufacturingOrder($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManufacturingOrderList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetManufacturingOrderList(\StructType\Context $context, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManufacturingOrderList($context, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManufacturingOrderListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetManufacturingOrderListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManufacturingOrderListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetZ106338AT941112215352AAAAAAAAAFI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetMOOperationResponse|bool
     */
    public function GetZ106338AT941112215352AAAAAAAAAFI(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZ106338AT941112215352AAAAAAAAAFI($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedComponentMOsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedComponentMOsList(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedComponentMOsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedComponentMOsListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedComponentMOsListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedComponentMOsListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedManufacturingOrder
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetRelatedManufacturingOrder_65513b6dc54122b69c6fa0a7ca1a5481(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedManufacturingOrder($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMfgDemand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetRelatedMfgDemand(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMfgDemand($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMfgDemandTopLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetManufacturingOrderResponse|bool
     */
    public function GetRelatedMfgDemandTopLevel(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMfgDemandTopLevel($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoMaterialsList
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetMOComponentListResponse|bool
     */
    public function GetRelatedMoMaterialsList_efb46d61b9c599ef69e186fee2f86ef7(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoMaterialsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoOperation
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @return \StructType\GetMOOperationResponse|bool
     */
    public function GetRelatedMoOperation_65513b6dc54122b69c6fa0a7ca1a5481(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoOperation($context, $domainKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoOperationsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetMOOperationListResponse|bool
     */
    public function GetRelatedMoOperationsList(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoOperationsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedMoOperationsListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetMOOperationListResponse|bool
     */
    public function GetRelatedMoOperationsListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedMoOperationsListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedSplitsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\ManufacturingOrderKey $domainKey
     * @param \StructType\ViewDfn $viewDfn
     * @param \StructType\SortDfn $sortDfn
     * @param \StructType\SubsetDfn $subsetDfn
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedSplitsList(\StructType\Context $context, \StructType\ManufacturingOrderKey $domainKey, \StructType\ViewDfn $viewDfn, \StructType\SortDfn $sortDfn, \StructType\SubsetDfn $subsetDfn, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedSplitsList($context, $domainKey, $viewDfn, $sortDfn, $subsetDfn, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedSplitsListNext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param string $queryName
     * @param string $maxReturned
     * @return \StructType\GetManufacturingOrderListResponse|bool
     */
    public function GetRelatedSplitsListNext(\StructType\Context $context, $queryName, $maxReturned)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedSplitsListNext($context, $queryName, $maxReturned));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\ArrayOfReasonCode|\ArrayType\ArrayOfSortDfn|\ArrayType\ArrayOfSubsetDfn|\ArrayType\ArrayOfTemplateDfn|\ArrayType\ArrayOfViewDfn|\StructType\DomainClassInfo|\StructType\GetManufacturingOrderListResponse|\StructType\GetManufacturingOrderResponse|\StructType\GetMOComponentListResponse|\StructType\GetMOComponentResponse|\StructType\GetMOOperationListResponse|\StructType\GetMOOperationResponse|\StructType\GetMoreCommentTextResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
