<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteMOOperation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOOperationKey $domainKey
     * @param string $reasonCode
     * @return \StructType\MaintenanceResponse|bool
     */
    public function DeleteMOOperation(\StructType\Context $context, \StructType\MOOperationKey $domainKey, $reasonCode)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMOOperation($context, $domainKey, $reasonCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMOComponent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Context $context
     * @param \StructType\MOComponentKey $domainKey
     * @param string $reasonCode
     * @return \StructType\MaintenanceResponse|bool
     */
    public function DeleteMOComponent(\StructType\Context $context, \StructType\MOComponentKey $domainKey, $reasonCode)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMOComponent($context, $domainKey, $reasonCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MaintenanceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
