<?php

namespace EnumType;

/**
 * This class stands for WarningType EnumType
 * @subpackage Enumerations
 */
class WarningType
{
    /**
     * Constant for value 'status'
     * @return string 'status'
     */
    const VALUE_STATUS = 'status';
    /**
     * Constant for value 'information'
     * @return string 'information'
     */
    const VALUE_INFORMATION = 'information';
    /**
     * Constant for value 'warning'
     * @return string 'warning'
     */
    const VALUE_WARNING = 'warning';
    /**
     * Constant for value 'error'
     * @return string 'error'
     */
    const VALUE_ERROR = 'error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STATUS
     * @uses self::VALUE_INFORMATION
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STATUS,
            self::VALUE_INFORMATION,
            self::VALUE_WARNING,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
