<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplementariesOfferResp StructType
 * @subpackage Structs
 */
class SupplementariesOfferResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The supplementaries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SupplementaryTariffOffer[]
     */
    public $supplementaries;
    /**
     * Constructor method for SupplementariesOfferResp
     * @uses SupplementariesOfferResp::setError()
     * @uses SupplementariesOfferResp::setSupplementaries()
     * @param \StructType\RespError $error
     * @param \StructType\SupplementaryTariffOffer[] $supplementaries
     */
    public function __construct(\StructType\RespError $error = null, array $supplementaries = array())
    {
        $this
            ->setError($error)
            ->setSupplementaries($supplementaries);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\SupplementariesOfferResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get supplementaries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SupplementaryTariffOffer[]|null
     */
    public function getSupplementaries()
    {
        return isset($this->supplementaries) ? $this->supplementaries : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplementaries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementaries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementariesForArrayConstraintsFromSetSupplementaries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementariesOfferRespSupplementariesItem) {
            // validation for constraint: itemType
            if (!$supplementariesOfferRespSupplementariesItem instanceof \StructType\SupplementaryTariffOffer) {
                $invalidValues[] = is_object($supplementariesOfferRespSupplementariesItem) ? get_class($supplementariesOfferRespSupplementariesItem) : sprintf('%s(%s)', gettype($supplementariesOfferRespSupplementariesItem), var_export($supplementariesOfferRespSupplementariesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The supplementaries property can only contain items of type \StructType\SupplementaryTariffOffer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set supplementaries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SupplementaryTariffOffer[] $supplementaries
     * @return \StructType\SupplementariesOfferResp
     */
    public function setSupplementaries(array $supplementaries = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementariesArrayErrorMessage = self::validateSupplementariesForArrayConstraintsFromSetSupplementaries($supplementaries))) {
            throw new \InvalidArgumentException($supplementariesArrayErrorMessage, __LINE__);
        }
        if (is_null($supplementaries) || (is_array($supplementaries) && empty($supplementaries))) {
            unset($this->supplementaries);
        } else {
            $this->supplementaries = $supplementaries;
        }
        return $this;
    }
    /**
     * Add item to supplementaries value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplementaryTariffOffer $item
     * @return \StructType\SupplementariesOfferResp
     */
    public function addToSupplementaries(\StructType\SupplementaryTariffOffer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplementaryTariffOffer) {
            throw new \InvalidArgumentException(sprintf('The supplementaries property can only contain items of type \StructType\SupplementaryTariffOffer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->supplementaries[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplementariesOfferResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
