<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for respError StructType
 * @subpackage Structs
 */
class RespError extends AbstractStructBase
{
    /**
     * The errCode
     * @var int
     */
    public $errCode;
    /**
     * The errInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errInfo;
    /**
     * The stackTrace
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $stackTrace;
    /**
     * Constructor method for respError
     * @uses RespError::setErrCode()
     * @uses RespError::setErrInfo()
     * @uses RespError::setStackTrace()
     * @param int $errCode
     * @param string $errInfo
     * @param string[] $stackTrace
     */
    public function __construct($errCode = null, $errInfo = null, array $stackTrace = array())
    {
        $this
            ->setErrCode($errCode)
            ->setErrInfo($errInfo)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get errCode value
     * @return int|null
     */
    public function getErrCode()
    {
        return $this->errCode;
    }
    /**
     * Set errCode value
     * @param int $errCode
     * @return \StructType\RespError
     */
    public function setErrCode($errCode = null)
    {
        // validation for constraint: int
        if (!is_null($errCode) && !(is_int($errCode) || ctype_digit($errCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errCode, true), gettype($errCode)), __LINE__);
        }
        $this->errCode = $errCode;
        return $this;
    }
    /**
     * Get errInfo value
     * @return string|null
     */
    public function getErrInfo()
    {
        return $this->errInfo;
    }
    /**
     * Set errInfo value
     * @param string $errInfo
     * @return \StructType\RespError
     */
    public function setErrInfo($errInfo = null)
    {
        // validation for constraint: string
        if (!is_null($errInfo) && !is_string($errInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errInfo, true), gettype($errInfo)), __LINE__);
        }
        $this->errInfo = $errInfo;
        return $this;
    }
    /**
     * Get stackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStackTrace()
    {
        return isset($this->stackTrace) ? $this->stackTrace : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStackTrace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStackTrace method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStackTraceForArrayConstraintsFromSetStackTrace(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $respErrorStackTraceItem) {
            // validation for constraint: itemType
            if (!is_string($respErrorStackTraceItem)) {
                $invalidValues[] = is_object($respErrorStackTraceItem) ? get_class($respErrorStackTraceItem) : sprintf('%s(%s)', gettype($respErrorStackTraceItem), var_export($respErrorStackTraceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stackTrace property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $stackTrace
     * @return \StructType\RespError
     */
    public function setStackTrace(array $stackTrace = array())
    {
        // validation for constraint: array
        if ('' !== ($stackTraceArrayErrorMessage = self::validateStackTraceForArrayConstraintsFromSetStackTrace($stackTrace))) {
            throw new \InvalidArgumentException($stackTraceArrayErrorMessage, __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->stackTrace);
        } else {
            $this->stackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Add item to stackTrace value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RespError
     */
    public function addToStackTrace($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The stackTrace property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stackTrace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RespError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
