<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuredPersonParms StructType
 * @subpackage Structs
 */
class InsuredPersonParms extends AbstractStructBase
{
    /**
     * The cancellationAmount
     * @var float
     */
    public $cancellationAmount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The sex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sex;
    /**
     * The surname
     * @var string
     */
    public $surname;
    /**
     * The tariff
     * @var string
     */
    public $tariff;
    /**
     * The supplementaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplementaries
     */
    public $supplementaries;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The itemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemDescription;
    /**
     * Constructor method for InsuredPersonParms
     * @uses InsuredPersonParms::setCancellationAmount()
     * @uses InsuredPersonParms::setCurrency()
     * @uses InsuredPersonParms::setName()
     * @uses InsuredPersonParms::setPin()
     * @uses InsuredPersonParms::setSex()
     * @uses InsuredPersonParms::setSurname()
     * @uses InsuredPersonParms::setTariff()
     * @uses InsuredPersonParms::setSupplementaries()
     * @uses InsuredPersonParms::setItemId()
     * @uses InsuredPersonParms::setItemName()
     * @uses InsuredPersonParms::setItemDescription()
     * @param float $cancellationAmount
     * @param string $currency
     * @param string $name
     * @param string $pin
     * @param string $sex
     * @param string $surname
     * @param string $tariff
     * @param \StructType\Supplementaries $supplementaries
     * @param string $itemId
     * @param string $itemName
     * @param string $itemDescription
     */
    public function __construct($cancellationAmount = null, $currency = null, $name = null, $pin = null, $sex = null, $surname = null, $tariff = null, \StructType\Supplementaries $supplementaries = null, $itemId = null, $itemName = null, $itemDescription = null)
    {
        $this
            ->setCancellationAmount($cancellationAmount)
            ->setCurrency($currency)
            ->setName($name)
            ->setPin($pin)
            ->setSex($sex)
            ->setSurname($surname)
            ->setTariff($tariff)
            ->setSupplementaries($supplementaries)
            ->setItemId($itemId)
            ->setItemName($itemName)
            ->setItemDescription($itemDescription);
    }
    /**
     * Get cancellationAmount value
     * @return float|null
     */
    public function getCancellationAmount()
    {
        return $this->cancellationAmount;
    }
    /**
     * Set cancellationAmount value
     * @param float $cancellationAmount
     * @return \StructType\InsuredPersonParms
     */
    public function setCancellationAmount($cancellationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationAmount) && !(is_float($cancellationAmount) || is_numeric($cancellationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationAmount, true), gettype($cancellationAmount)), __LINE__);
        }
        $this->cancellationAmount = $cancellationAmount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\InsuredPersonParms
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\InsuredPersonParms
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \StructType\InsuredPersonParms
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get sex value
     * @return string|null
     */
    public function getSex()
    {
        return $this->sex;
    }
    /**
     * Set sex value
     * @param string $sex
     * @return \StructType\InsuredPersonParms
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        $this->sex = $sex;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\InsuredPersonParms
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param string $tariff
     * @return \StructType\InsuredPersonParms
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get supplementaries value
     * @return \StructType\Supplementaries|null
     */
    public function getSupplementaries()
    {
        return $this->supplementaries;
    }
    /**
     * Set supplementaries value
     * @param \StructType\Supplementaries $supplementaries
     * @return \StructType\InsuredPersonParms
     */
    public function setSupplementaries(\StructType\Supplementaries $supplementaries = null)
    {
        $this->supplementaries = $supplementaries;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\InsuredPersonParms
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\InsuredPersonParms
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get itemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->itemDescription;
    }
    /**
     * Set itemDescription value
     * @param string $itemDescription
     * @return \StructType\InsuredPersonParms
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        $this->itemDescription = $itemDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuredPersonParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
